package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.OrderService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class OrderServiceImpl extends BaseDaoServiceImpl implements OrderService {


    private static final Log orderLog = LogFactory.getLog("order");
    
    @Override
    public Long insert(Order order) throws ServiceException, ServiceDaoException {


        orderLog.info(" insert data : " + order);

        if (order == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        order.setCreateAt(currentTimeMillis);
        order.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(order);
        } catch (DaoException e) {
            orderLog.error(" insert wrong : " + order);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        orderLog.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Order> insertList(List<Order> orderList) throws ServiceException, ServiceDaoException {


        orderLog.info(" insert lists : " + (orderList == null ? "null" : orderList.size()));

        List<Order> resultList = null;

        if (CollectionUtils.isEmpty(orderList)) {
            return new ArrayList<Order>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Order order : orderList) {
            order.setCreateAt(currentTimeMillis);
            order.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Order>) dao.batchSave(orderList);
        } catch (DaoException e) {
            orderLog.error(" insert list wrong : " + orderList);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        orderLog.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        orderLog.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Order.class, id);
        } catch (DaoException e) {
            orderLog.error(" delete wrong : " + id);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        orderLog.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Order order) throws ServiceException, ServiceDaoException {


        orderLog.info(" update data : " + (order == null ? "null" : order.getId()));

        boolean result = false;

        if (order == null) {
            return true;
        }

        order.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(order);
        } catch (DaoException e) {
            orderLog.error(" update wrong : " + order);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" update data success : " + order);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Order> orderList) throws ServiceException, ServiceDaoException {


        orderLog.info(" update lists : " + (orderList == null ? "null" : orderList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(orderList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Order order : orderList) {
            order.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(orderList);
        } catch (DaoException e) {
            orderLog.error(" update list wrong : " + orderList);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        orderLog.info(" update lists success : " + orderList.size());

        return result;
    }


    @Override
    public Order getObjectById(Long id) throws ServiceException, ServiceDaoException {


        orderLog.info(" get data : " + id);

        Order order = null;

        if (id == null) {
            return order;
        }

        try {
            order = (Order) dao.get(Order.class, id);
        } catch (DaoException e) {
            orderLog.error(" get wrong : " + id);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        orderLog.info(" get data success : " + id);

        return order;
    }


    @Override
    public List<Order> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        orderLog.info(" get lists : " + (ids == null ? "null" : ids));

        List<Order> order = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Order>();
        }

        try {
            order = (List<Order>) dao.getList(Order.class, ids);
        } catch (DaoException e) {
            orderLog.error(" get wrong : " + ids);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        orderLog.info(" get data success : " + (order == null ? "null" : order.size()));

        return order;
    }

    @Override
    public List<Long> getOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        orderLog.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrderIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            orderLog.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countOrderIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getOrderIdsAll", new Object[]{});
        } catch (DaoException e) {
            orderLog.error(" count by getOrderIds ");
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            orderLog.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Long getOrderIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get id by orderNo  : " + orderNo);
        }
        Long id = null;
        try {
            id = (Long) dao.getMapping("getOrderIdByOrderNo", new Object[]{orderNo, orderNo});
        } catch (DaoException e) {
            orderLog.error(" get id wrong by orderNo : " + orderNo);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public Long getOrderIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {
        orderLog.info(" get id by orderNo  : " + orderNo + " and additional : " + additional);

        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get id by orderNo  : " + orderNo + " and additional : " + additional);
        }
        Long id = null;
        try {
            id = (Long) dao.getMapping("getOrderIdByOrderNoAndAdditional", new Object[]{orderNo, additional});
        } catch (DaoException e) {
            orderLog.error(" get id wrong by orderNo : " + orderNo + " and additional : " + additional);
            orderLog.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info(" get id success : " + id);
        }
        return id;
    }

}

