package com.ptteng.wealth.finance.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.LoanProductService;
import com.ptteng.wealth.finance.util.FinanceConstant;
import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.service.LoanApplyService;
import com.ptteng.wealth.finance.service.OrderService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component("LoanApplyServiceImpl")
public class LoanApplyServiceImpl extends BaseDaoServiceImpl implements LoanApplyService {


    private static final Log log = LogFactory.getLog(LoanApplyServiceImpl.class);


    @Autowired
    private OrderService orderService;

    @Autowired
    private FundService fundService;


    @Autowired
    private LoanProductService loanProductService;


    @Override
    public Long insert(LoanApply loanApply) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + loanApply);

        if (loanApply == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        loanApply.setCreateAt(currentTimeMillis);
        loanApply.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(loanApply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + loanApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<LoanApply> insertList(List<LoanApply> loanApplyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (loanApplyList == null ? "null" : loanApplyList.size()));

        List<LoanApply> resultList = null;

        if (CollectionUtils.isEmpty(loanApplyList)) {
            return new ArrayList<LoanApply>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (LoanApply loanApply : loanApplyList) {
            loanApply.setCreateAt(currentTimeMillis);
            loanApply.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<LoanApply>) dao.batchSave(loanApplyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + loanApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(LoanApply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(LoanApply loanApply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (loanApply == null ? "null" : loanApply.getId()));

        boolean result = false;

        if (loanApply == null) {
            return true;
        }

        loanApply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(loanApply);
        } catch (DaoException e) {
            log.error(" update wrong : " + loanApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + loanApply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<LoanApply> loanApplyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (loanApplyList == null ? "null" : loanApplyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(loanApplyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (LoanApply loanApply : loanApplyList) {
            loanApply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(loanApplyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + loanApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + loanApplyList.size());

        return result;
    }


    @Override
    public LoanApply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        LoanApply loanApply = null;

        if (id == null) {
            return loanApply;
        }

        try {
            loanApply = (LoanApply) dao.get(LoanApply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return loanApply;
    }


    @Override
    public List<LoanApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<LoanApply> loanApply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LoanApply>();
        }

        try {
            loanApply = (List<LoanApply>) dao.getList(LoanApply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (loanApply == null ? "null" : loanApply.size()));

        return loanApply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getLoanApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by orderNo  : " + orderNo + " additional : " + additional);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getLoanApplyIdByOrderNoAndAdditional", new Object[]{orderNo, additional});
        } catch (DaoException e) {
            log.error(" get id wrong by orderNo  : " + orderNo + " additional : " + additional);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getLoanApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLoanApplyIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getLoanApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLoanApplyIdsByStatus", new Object[]{status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getLoanApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLoanApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getLoanApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLoanApplyIdsByUidAndType", new Object[]{uid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getLoanApplyIdsByUidAndOrderType(Long uid, Integer orderType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,type,start,limit  : " + uid + " , " + orderType + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLoanApplyIdsByUidAndOrderType", new Object[]{uid, orderType}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,orderType,start,limit)  : " + uid + " , " + orderType + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;

    }

    @Override
    public Integer countLoanApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,type  : " + uid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getLoanApplyIdsByUidAndType", new Object[]{uid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,type)  : " + uid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countLoanApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getLoanApplyIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countLoanApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,status  : " + uid + " , " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getLoanApplyIdsByUidAndStatus", new Object[]{uid, status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,status)  : " + uid + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getLoanApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getLoanApplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countLoanApplyIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getLoanApplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getLoanApplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Boolean addLoanApply(Order order, Long loanProductId, User user) throws ServiceException, ServiceDaoException {
        log.info("add loan apply oid : " + order.getId() + " loan product id : " + loanProductId + " user : " + user.getId());
        LoanProduct loanProduct = loanProductService.getObjectById(loanProductId);

        Long id = getLoanApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getAdditional());
        if (null == id) {
            LoanApply loanApply = new LoanApply();
            Boolean result = false;

//            BigDecimal money = order.getPriceTot().multiply(loanProduct.getRatio()).divide(new BigDecimal(100), 3, BigDecimal.ROUND_HALF_UP);
//            BigDecimal debtCount = order.getPriceTot().subtract(money);

            loanApply.setUid(order.getUid());
            loanApply.setUserMobile(user.getMobile());
            loanApply.setUserName(user.getName());
            loanApply.setOrderID(order.getId());
            loanApply.setOrderNo(order.getOrderNo());
            loanApply.setTotal(order.getPriceTot());
//            loanApply.setDebtCount(debtCount);
            loanApply.setDebtCount(order.getPriceTot());
            loanApply.setRate(loanProduct.getRate());
            loanApply.setOverRate(loanProduct.getOverRate());
            loanApply.setStatus(LoanApply.STATUS_VERIFYING);
            loanApply.setType(LoanApply.TYPE_VERIFYING);
            loanApply.setVerifyAt(0L);
            loanApply.setRepayWay(LoanApply.REPAYWAY_1);
            loanApply.setSecondVerifyAt(0L);
            loanApply.setRepayLine(loanProduct.getRepayLine());
            loanApply.setOrderType(loanProduct.getPayManner());
            loanApply.setAdditional(order.getAdditional());
            id = insert(loanApply);

        }
        log.info("now insert loanApply success and loanApplyId is " + id);

        return true;
    }

    @Override
    public Boolean addSmallLoanApply(Order order, User user, Boolean ifVerify) throws ServiceException, ServiceDaoException {
        log.info("add small loan apply order : " + order.getId() + " user : " + user.getId() + " if verify : " + ifVerify);
        Long id = getLoanApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getAdditional());
        if (null == id) {
            LoanApply loanApply = new LoanApply();
            Boolean result = false;

            if (ifVerify) {
                loanApply.setStatus(LoanApply.STATUS_PASS);
                loanApply.setType(LoanApply.TYPE_REPAY);
                loanApply.setDebtAt(System.currentTimeMillis());
            } else {
                loanApply.setStatus(LoanApply.STATUS_VERIFYING);
                loanApply.setType(LoanApply.TYPE_VERIFYING);
            }

            loanApply.setUid(order.getUid());
            loanApply.setUserMobile(user.getMobile());
            loanApply.setUserName(user.getName());
            loanApply.setOrderID(order.getId());
            loanApply.setOrderNo(order.getOrderNo());
            loanApply.setTotal(order.getPriceTot());
            loanApply.setDebtCount(order.getPriceTot());
            loanApply.setVerifyAt(System.currentTimeMillis());
            loanApply.setRepayWay(LoanApply.REPAYWAY_1);
            loanApply.setSecondVerifyAt(System.currentTimeMillis());
            loanApply.setOrderType(LoanApply.ORDER_TYPE_SMALL);
            loanApply.setRate(BigDecimal.ZERO);
            loanApply.setOverRate(BigDecimal.ZERO);
            loanApply.setRepayLine(Integer.MAX_VALUE);
            loanApply.setAdditional(order.getAdditional());
            id = insert(loanApply);

        }
        log.info("now insert smallLoanApply success and loanApplyId is " + id);

        return true;
    }

}

