package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Invoice;
import com.ptteng.wealth.finance.service.InvoiceService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class InvoiceServiceImpl extends BaseDaoServiceImpl implements InvoiceService {


    private static final Log log = LogFactory.getLog(InvoiceServiceImpl.class);


    @Override
    public Long insert(Invoice invoice) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + invoice);

        if (invoice == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        invoice.setCreateAt(currentTimeMillis);
        invoice.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(invoice);
        } catch (DaoException e) {
            log.error(" insert wrong : " + invoice);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Invoice> insertList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (invoiceList == null ? "null" : invoiceList.size()));

        List<Invoice> resultList = null;

        if (CollectionUtils.isEmpty(invoiceList)) {
            return new ArrayList<Invoice>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Invoice invoice : invoiceList) {
            invoice.setCreateAt(currentTimeMillis);
            invoice.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Invoice>) dao.batchSave(invoiceList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + invoiceList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Invoice.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Invoice invoice) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (invoice == null ? "null" : invoice.getId()));

        boolean result = false;

        if (invoice == null) {
            return true;
        }

        invoice.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(invoice);
        } catch (DaoException e) {
            log.error(" update wrong : " + invoice);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + invoice);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (invoiceList == null ? "null" : invoiceList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(invoiceList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Invoice invoice : invoiceList) {
            invoice.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(invoiceList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + invoiceList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + invoiceList.size());

        return result;
    }


    @Override
    public Invoice getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Invoice invoice = null;

        if (id == null) {
            return invoice;
        }

        try {
            invoice = (Invoice) dao.get(Invoice.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return invoice;
    }


    @Override
    public List<Invoice> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Invoice> invoice = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Invoice>();
        }

        try {
            invoice = (List<Invoice>) dao.getList(Invoice.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (invoice == null ? "null" : invoice.size()));

        return invoice;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getInvoiceIdsByUidAndType", new Object[]{uid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getInvoiceIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,type  : " + uid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getInvoiceIdsByUidAndType", new Object[]{uid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,type)  : " + uid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getInvoiceIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getInvoiceIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getInvoiceIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countInvoiceIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getInvoiceIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getInvoiceIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

