package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Draw;
import com.ptteng.wealth.finance.service.DrawService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class DrawServiceImpl extends BaseDaoServiceImpl implements DrawService {

 

	private static final Log log = LogFactory.getLog(DrawServiceImpl.class);



		   
		@Override
		public Long insert(Draw draw)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + draw);

		if (draw == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		draw.setCreateAt(currentTimeMillis);
		draw.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(draw);
		} catch (DaoException e) {
			log.error(" insert wrong : " + draw);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Draw> insertList(List<Draw> drawList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (drawList == null ? "null" : drawList.size()));
      
		List<Draw> resultList = null;

		if (CollectionUtils.isEmpty(drawList)) {
			return new ArrayList<Draw>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Draw draw : drawList) {
			draw.setCreateAt(currentTimeMillis);
			draw.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Draw>) dao.batchSave(drawList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + drawList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Draw.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Draw draw)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (draw == null ? "null" : draw.getId()));

		boolean result = false;

		if (draw == null) {
			return true;
		}

		draw.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(draw);
		} catch (DaoException e) {
			log.error(" update wrong : " + draw);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + draw);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Draw> drawList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (drawList == null ? "null" : drawList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(drawList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Draw draw : drawList) {
			draw.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(drawList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + drawList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + drawList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Draw getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Draw draw = null;

		if (id == null) {
			return draw;
		}

		try {
			draw = (Draw) dao.get(Draw.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return draw;		
		}	
		  
    	   
		@Override
		public List<Draw> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Draw> draw = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Draw>();
		}

		try {
			draw = (List<Draw>) dao.getList(Draw.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (draw == null ? "null" : draw.size()));
    
		return draw;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDrawIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getDrawIdsByUidAndStatus", new Object[] { uid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit)  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDrawIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getDrawIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDrawIdsByUidAndPid(Long uid,Long pid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,pid,start,limit  : " + uid+" , "+pid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getDrawIdsByUidAndPid", new Object[] { uid,pid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,pid,start,limit)  : " + uid+" , "+pid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDrawIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,status  : " + uid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getDrawIdsByUidAndStatus", new Object[] { uid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,status)  : " + uid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDrawIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getDrawIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDrawIdsByUidAndPid(Long uid,Long pid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,pid  : " + uid+" , "+pid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getDrawIdsByUidAndPid", new Object[] { uid,pid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,pid)  : " + uid+" , "+pid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getDrawIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getDrawIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countDrawIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getDrawIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getDrawIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

