package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.DebtApply;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.DebtApplyService;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.LoanProductService;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.user.model.User;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


public class DebtApplyServiceImpl extends BaseDaoServiceImpl implements DebtApplyService {


    private static final Log log = LogFactory.getLog(DebtApplyServiceImpl.class);


    @Autowired
    private OrderService orderService;

    @Autowired
    private FundService fundService;

    @Autowired
    private LoanProductService loanProductService;

    @Override
    public Long insert(DebtApply debtApply) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + debtApply);

        if (debtApply == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        debtApply.setCreateAt(currentTimeMillis);
        debtApply.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(debtApply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + debtApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DebtApply> insertList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (debtApplyList == null ? "null" : debtApplyList.size()));

        List<DebtApply> resultList = null;

        if (CollectionUtils.isEmpty(debtApplyList)) {
            return new ArrayList<DebtApply>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DebtApply debtApply : debtApplyList) {
            debtApply.setCreateAt(currentTimeMillis);
            debtApply.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DebtApply>) dao.batchSave(debtApplyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + debtApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DebtApply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DebtApply debtApply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (debtApply == null ? "null" : debtApply.getId()));

        boolean result = false;

        if (debtApply == null) {
            return true;
        }

        debtApply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(debtApply);
        } catch (DaoException e) {
            log.error(" update wrong : " + debtApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + debtApply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (debtApplyList == null ? "null" : debtApplyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(debtApplyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DebtApply debtApply : debtApplyList) {
            debtApply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(debtApplyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + debtApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + debtApplyList.size());

        return result;
    }


    @Override
    public DebtApply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DebtApply debtApply = null;

        if (id == null) {
            return debtApply;
        }

        try {
            debtApply = (DebtApply) dao.get(DebtApply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return debtApply;
    }


    @Override
    public List<DebtApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DebtApply> debtApply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DebtApply>();
        }

        try {
            debtApply = (List<DebtApply>) dao.getList(DebtApply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (debtApply == null ? "null" : debtApply.size()));

        return debtApply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getDebtApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by orderNo  : " + orderNo + " additional : " + additional);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getDebtApplyIdByOrderNoAndAdditional", new Object[]{orderNo, additional});
        } catch (DaoException e) {
            log.error(" get id wrong by orderNo  : " + orderNo + " additional : " + additional);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDebtApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDebtApplyIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getDebtApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDebtApplyIdsByStatus", new Object[]{status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDebtApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDebtApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getDebtApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDebtApplyIdsByUidAndType", new Object[]{uid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Integer countDebtApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,type  : " + uid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getDebtApplyIdsByUidAndType", new Object[]{uid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,type)  : " + uid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }

    @Override
    public List<DebtApply> getObjectsBySql(Class clz, String sql) throws ServiceException, ServiceDaoException {

        List<DebtApply> debtApplies = new ArrayList<>();
        DebtApply debtApply = new DebtApply();

        try {

            Object results = this.dao.excuteSimpleSql(sql, clz);
            log.info(sql + " result is not list " + results + " instance " + results.getClass());

            int i = 0;
            if(results instanceof ArrayList) {
                ArrayList resultArrays = (ArrayList) results;
                for (Object result : resultArrays) {
                    Object[] rs = (Object[]) result;

                    debtApply = object2debtApply(rs);

                    debtApplies.add(debtApply);
                }
            }else {
                Object[] rs=(Object[])results;

                debtApply = object2debtApply(rs);

                debtApplies.add(debtApply);
            }

        } catch (DaoException var10) {
            log.error(" count by getPuserIds " + sql);
            log.error(var10);
            var10.printStackTrace();
            throw new ServiceDaoException(var10);
        }

        return debtApplies;
    }

    @Override
    public Long getObjectsByCountSql(String sql) throws ServiceException, ServiceDaoException {
        Long count = 0L;

        try {

            Object results = this.dao.excuteSimpleSql(sql, DebtApply.class);
            Object[] rs = (Object[])results;
            count = longValue(rs[0]);


        } catch (DaoException var10) {
            log.error(" count by sql " + sql);
            log.error(var10);
            var10.printStackTrace();
            throw new ServiceDaoException(var10);
        }

        return count;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDebtApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getDebtApplyIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDebtApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,status  : " + uid + " , " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getDebtApplyIdsByUidAndStatus", new Object[]{uid, status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,status)  : " + uid + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getDebtApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDebtApplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDebtApplyIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDebtApplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDebtApplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Boolean addDebtApply(Order order, Long loanProductId, User user) throws ServiceException, ServiceDaoException {

        LoanProduct loanProduct = loanProductService.getObjectById(loanProductId);
        DebtApply debtApply = new DebtApply();
        Boolean result = false;

        BigDecimal money = order.getPriceTot().multiply(loanProduct.getRatio()).divide(new BigDecimal("100"), 3, BigDecimal.ROUND_HALF_UP);
        BigDecimal debtCount = order.getPriceTot().subtract(money);

        Long now = System.currentTimeMillis();
        debtApply.setUid(order.getUid());
        debtApply.setUserMobile(user.getMobile());
        debtApply.setUserName(user.getName());
        debtApply.setOrderID(order.getId());
        debtApply.setOrderNo(order.getOrderNo());
        debtApply.setTotal(order.getPriceTot());
        debtApply.setDebtCount(debtCount);
        debtApply.setRate(loanProduct.getRate());
        debtApply.setOverRate(loanProduct.getOverRate());
        debtApply.setStatus(DebtApply.STATUS_VERIFYING);
        debtApply.setType(DebtApply.TYPE_VERIFYING);
        debtApply.setOrderType(DebtApply.ORDER_TYPE_DEBT);
        debtApply.setVerifyAt(0L);
        debtApply.setRepayWay(DebtApply.REPAYWAY_1);
        debtApply.setSecondVerifyAt(0L);
		debtApply.setRepayLine(loanProduct.getRepayLine());
        debtApply.setAdditional(order.getAdditional());
        Long debtApplyId = insert(debtApply);
        log.info("now insert debtApply success and debtApplyId is " + debtApplyId);

        return result;
    }


    public DebtApply object2debtApply(Object[] rs){

        DebtApply debtApply = new DebtApply();
        debtApply.setId(longValue(rs[0]));
        debtApply.setUid(longValue(rs[1]));
        debtApply.setUserMobile(stringValue(rs[2]));
        debtApply.setUserName(stringValue(rs[3]));
        debtApply.setOrderNo(stringValue(rs[4]));
        debtApply.setOrderID(longValue(rs[5]));
        debtApply.setTotal(bigDecimalValue(rs[6]));
        debtApply.setDebtCount(bigDecimalValue(rs[7]));
        debtApply.setRate(bigDecimalValue(rs[8]));
        debtApply.setOverRate(bigDecimalValue(rs[9]));
        debtApply.setRepayWay(intValue(rs[10]));
        debtApply.setReason(stringValue(rs[11]));
        debtApply.setStatus(intValue(rs[12]));
        debtApply.setType(intValue(rs[13]));
        debtApply.setOrderType(intValue(rs[14]));
        debtApply.setRepayLine(intValue(rs[15]));
        debtApply.setRepayTot(bigDecimalValue(rs[16]));
        debtApply.setOverAt(longValue(rs[17]));
        debtApply.setVerifyAt(longValue(rs[18]));
        debtApply.setSecondVerifyAt(longValue(rs[19]));
        debtApply.setVerifyBy(longValue(rs[20]));
        debtApply.setSecondVerifyBy(longValue(rs[21]));
        debtApply.setClearInte(bigDecimalValue(rs[22]));
        debtApply.setClearOverInte(bigDecimalValue(rs[23]));
        debtApply.setOverDayCount(bigDecimalValue(rs[24]));
        debtApply.setClearAt(longValue(rs[25]));
        debtApply.setCreateBy(longValue(rs[26]));
        debtApply.setUpdateBy(longValue(rs[27]));
        debtApply.setUpdateAt(longValue(rs[28]));
        debtApply.setCreateAt(longValue(rs[29]));
        debtApply.setDebtAt(longValue(rs[30]));
        debtApply.setAdditional(stringValue(rs[31]));

        return debtApply;
    }

    public Long longValue(Object rs){
        if(null == rs){
            return null;
        }else {
            return Long.valueOf(rs.toString());
        }
    }

    public String stringValue(Object rs){
        if(null == rs){
            return null;
        }else {
            return rs.toString();
        }
    }

    public BigDecimal bigDecimalValue(Object rs){
        if(null == rs || "".equals(rs)){
            return null;
        }else {
            return new BigDecimal(rs.toString());
        }
    }

    public Integer intValue(Object rs){
        if(null == rs){
            return null;
        }else {
            return Integer.valueOf(rs.toString());
        }
    }

}

