/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.ProductDaily;
import com.ptteng.wealth.finance.service.DrawService;
import com.ptteng.wealth.finance.service.InvestService;
import com.ptteng.wealth.finance.service.ProductDailyService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProductDailyServiceImpl
extends BaseDaoServiceImpl
implements ProductDailyService {
    private InvestService investService;
    private DrawService drawService;
    private static final Log log = LogFactory.getLog(ProductDailyServiceImpl.class);

    public Long insert(ProductDaily productDaily) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + productDaily));
        if (productDaily == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        productDaily.setCreateAt(Long.valueOf(currentTimeMillis));
        productDaily.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)productDaily);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + productDaily));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ProductDaily> insertList(List<ProductDaily> productDailyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (productDailyList == null ? "null" : Integer.valueOf(productDailyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(productDailyList)) {
            return new ArrayList<ProductDaily>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProductDaily productDaily : productDailyList) {
            productDaily.setCreateAt(Long.valueOf(currentTimeMillis));
            productDaily.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(productDailyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + productDailyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ProductDaily.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ProductDaily productDaily) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (productDaily == null ? "null" : productDaily.getId())));
        boolean result = false;
        if (productDaily == null) {
            return true;
        }
        productDaily.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)productDaily);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + productDaily));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + productDaily));
        }
        return result;
    }

    public boolean updateList(List<ProductDaily> productDailyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (productDailyList == null ? "null" : Integer.valueOf(productDailyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(productDailyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProductDaily productDaily : productDailyList) {
            productDaily.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(productDailyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + productDailyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + productDailyList.size()));
        return result;
    }

    public ProductDaily getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ProductDaily productDaily = null;
        if (id == null) {
            return productDaily;
        }
        try {
            productDaily = (ProductDaily)this.dao.get(ProductDaily.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return productDaily;
    }

    public List<ProductDaily> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List productDaily = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProductDaily>();
        }
        try {
            productDaily = this.dao.getList(ProductDaily.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (productDaily == null ? "null" : Integer.valueOf(productDaily.size()))));
        return productDaily;
    }

    public List<Long> getProductDailyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductDailyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductDailyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProductDailyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProductDailyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public InvestService getInvestService() {
        return this.investService;
    }

    public void setInvestService(InvestService investService) {
        this.investService = investService;
    }

    public DrawService getDrawService() {
        return this.drawService;
    }

    public void setDrawService(DrawService drawService) {
        this.drawService = drawService;
    }

    public void addStatisticsDaily(Long uid, Long pid, BigDecimal amount, Integer type) throws ServiceException, ServiceDaoException {
        log.info((Object)(" uid = " + uid + " pid = " + pid + " amount = " + amount + " type = " + type));
        List<Long> productDailyIds = this.getProductDailyIds(0, 1);
        log.info((Object)(" history ids = " + productDailyIds.size()));
        Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
        log.info((Object)(" today is = " + ProductDailyServiceImpl.getDate(staticAt)));
        if (ProductDaily.INVEST.equals(type)) {
            log.info((Object)" invest ");
            List investIds = this.investService.getInvestIdsByUidAndPid(uid, pid, Integer.valueOf(0), Integer.valueOf(1));
            log.info((Object)(" user " + uid + " history investIds is = " + investIds));
            if (productDailyIds.size() > 0) {
                log.info((Object)" productDailyIds size >0 ");
                ProductDaily productDaily = this.getObjectById(productDailyIds.get(0));
                if (staticAt.equals(productDaily.getStaticAt())) {
                    log.info((Object)" staticAt is today  ");
                    if (investIds.size() > 0) {
                        log.info((Object)" investIds size = 0 ");
                    } else {
                        log.info((Object)" investIds size > 0 ");
                        productDaily.setBuyPersonSum(productDaily.getBuyPersonSum().add(new BigDecimal("1")));
                    }
                    productDaily.setBuyCount(productDaily.getBuyCount().add(new BigDecimal("1")));
                    productDaily.setBuySumAmount(productDaily.getBuySumAmount().add(amount));
                    this.update(productDaily);
                } else {
                    log.info((Object)" staticAt is not today  ");
                    ProductDaily productDaily1 = new ProductDaily();
                    productDaily1.setProductId(pid);
                    productDaily1.setStaticAt(staticAt);
                    if (investIds.size() > 0) {
                        log.info((Object)" investIds size = 0 ");
                    } else {
                        log.info((Object)" investIds size > 0 ");
                        productDaily1.setBuyPersonSum(new BigDecimal("1"));
                    }
                    productDaily1.setBuyCount(new BigDecimal("1"));
                    productDaily1.setBuySumAmount(amount);
                    productDaily1.setCreateBy(uid);
                    productDaily1.setUpdateBy(uid);
                    Long statisticsId = this.insert(productDaily1);
                    log.info((Object)(" statisticsId = " + statisticsId));
                }
            } else {
                log.info((Object)" productDailyIds size = 0 ");
                ProductDaily productDaily1 = new ProductDaily();
                productDaily1.setProductId(pid);
                productDaily1.setStaticAt(staticAt);
                if (investIds.size() <= 0) {
                    productDaily1.setBuyPersonSum(new BigDecimal("1"));
                }
                productDaily1.setBuyCount(new BigDecimal("1"));
                productDaily1.setBuySumAmount(amount);
                productDaily1.setCreateBy(uid);
                productDaily1.setUpdateBy(uid);
                Long statisticsId = this.insert(productDaily1);
                log.info((Object)(" statisticsId = " + statisticsId));
            }
        } else {
            log.info((Object)" withdrwal ");
            List drawIds = this.drawService.getDrawIdsByUidAndPid(uid, pid, Integer.valueOf(0), Integer.valueOf(1));
            log.info((Object)(" user " + uid + " history drawIds is = " + drawIds));
            HashMap params2 = new HashMap();
            if (productDailyIds.size() > 0) {
                log.info((Object)" productDailyIds size >0 ");
                ProductDaily productDaily = this.getObjectById(productDailyIds.get(0));
                if (staticAt.equals(productDaily.getStaticAt())) {
                    log.info((Object)" staticAt is today  ");
                    if (drawIds.size() > 0) {
                        log.info((Object)" drawIds size = 0 ");
                    } else {
                        log.info((Object)" drawIds size >0 ");
                        productDaily.setWithdrawalPersonSum(productDaily.getWithdrawalPersonSum().add(new BigDecimal("1")));
                    }
                    log.info((Object)("  withdrawalPersonSum = " + productDaily.getWithdrawalPersonSum()));
                    productDaily.setWithdrawalCount(productDaily.getWithdrawalCount().add(new BigDecimal("1")));
                    productDaily.setWithdrawalAmount(productDaily.getWithdrawalAmount().add(amount));
                    this.update(productDaily);
                } else {
                    log.info((Object)" staticAt is not today  ");
                    ProductDaily productDaily1 = new ProductDaily();
                    productDaily1.setProductId(pid);
                    productDaily1.setStaticAt(staticAt);
                    if (drawIds.size() <= 0) {
                        productDaily1.setWithdrawalPersonSum(new BigDecimal("1"));
                    }
                    log.info((Object)("  withdrawalPersonSum = " + productDaily1.getWithdrawalPersonSum()));
                    productDaily1.setWithdrawalCount(new BigDecimal("1"));
                    productDaily1.setWithdrawalAmount(amount);
                    productDaily1.setCreateBy(uid);
                    productDaily1.setUpdateBy(uid);
                    Long statisticsId = this.insert(productDaily1);
                    log.info((Object)(" statisticsId = " + statisticsId));
                }
            } else {
                log.info((Object)" productDailyIds size = 0 ");
                ProductDaily productDaily1 = new ProductDaily();
                productDaily1.setProductId(pid);
                productDaily1.setStaticAt(staticAt);
                if (drawIds.size() <= 0) {
                    productDaily1.setWithdrawalPersonSum(new BigDecimal("1"));
                }
                log.info((Object)("  withdrawalPersonSum = " + productDaily1.getWithdrawalPersonSum()));
                productDaily1.setWithdrawalCount(new BigDecimal("1"));
                productDaily1.setWithdrawalAmount(amount);
                productDaily1.setCreateBy(uid);
                productDaily1.setUpdateBy(uid);
                Long statisticsId = this.insert(productDaily1);
                log.info((Object)(" statisticsId = " + statisticsId));
            }
        }
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }
}

