/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.DebtApply;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.DebtApplyService;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.LoanProductService;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.user.model.User;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DebtApplyServiceImpl
extends BaseDaoServiceImpl
implements DebtApplyService {
    private static final Log log = LogFactory.getLog(DebtApplyServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private FundService fundService;
    @Autowired
    private LoanProductService loanProductService;

    public Long insert(DebtApply debtApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + debtApply));
        if (debtApply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        debtApply.setCreateAt(Long.valueOf(currentTimeMillis));
        debtApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)debtApply);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + debtApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<DebtApply> insertList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (debtApplyList == null ? "null" : Integer.valueOf(debtApplyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(debtApplyList)) {
            return new ArrayList<DebtApply>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DebtApply debtApply : debtApplyList) {
            debtApply.setCreateAt(Long.valueOf(currentTimeMillis));
            debtApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(debtApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + debtApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(DebtApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(DebtApply debtApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (debtApply == null ? "null" : debtApply.getId())));
        boolean result = false;
        if (debtApply == null) {
            return true;
        }
        debtApply.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)debtApply);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + debtApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + debtApply));
        }
        return result;
    }

    public boolean updateList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (debtApplyList == null ? "null" : Integer.valueOf(debtApplyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(debtApplyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (DebtApply debtApply : debtApplyList) {
            debtApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(debtApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + debtApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + debtApplyList.size()));
        return result;
    }

    public DebtApply getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        DebtApply debtApply = null;
        if (id == null) {
            return debtApply;
        }
        try {
            debtApply = (DebtApply)this.dao.get(DebtApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return debtApply;
    }

    public List<DebtApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List debtApply = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DebtApply>();
        }
        try {
            debtApply = this.dao.getList(DebtApply.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (debtApply == null ? "null" : Integer.valueOf(debtApply.size()))));
        return debtApply;
    }

    public Long getDebtApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderNo  : " + orderNo + " additional : " + additional));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getDebtApplyIdByOrderNoAndAdditional", new Object[]{orderNo, additional});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderNo  : " + orderNo + " additional : " + additional));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getDebtApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDebtApplyIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getDebtApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDebtApplyIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getDebtApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDebtApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getDebtApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDebtApplyIdsByUidAndType", new Object[]{uid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDebtApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,type  : " + uid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDebtApplyIdsByUidAndType", new Object[]{uid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,type)  : " + uid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<DebtApply> getObjectsBySql(Class clz, String sql) throws ServiceException, ServiceDaoException {
        ArrayList<DebtApply> debtApplies = new ArrayList<DebtApply>();
        DebtApply debtApply = new DebtApply();
        try {
            Object results = this.dao.excuteSimpleSql(sql, clz);
            log.info((Object)(sql + " result is not list " + results + " instance " + results.getClass()));
            boolean i = false;
            if (results instanceof ArrayList) {
                ArrayList resultArrays = (ArrayList)results;
                for (Object result : resultArrays) {
                    Object[] rs = (Object[])result;
                    debtApply = this.object2debtApply(rs);
                    debtApplies.add(debtApply);
                }
            } else {
                Object[] rs = (Object[])results;
                debtApply = this.object2debtApply(rs);
                debtApplies.add(debtApply);
            }
        }
        catch (DaoException var10) {
            log.error((Object)(" count by getPuserIds " + sql));
            log.error((Object)var10);
            var10.printStackTrace();
            throw new ServiceDaoException((Throwable)var10);
        }
        return debtApplies;
    }

    public Long getObjectsByCountSql(String sql) throws ServiceException, ServiceDaoException {
        Long count = 0L;
        try {
            Object results = this.dao.excuteSimpleSql(sql, Long.class);
            Object[] rs = (Object[])results;
            count = this.longValue(rs[0]);
        }
        catch (DaoException var10) {
            log.error((Object)(" count by sql " + sql));
            log.error((Object)var10);
            var10.printStackTrace();
            throw new ServiceDaoException((Throwable)var10);
        }
        return count;
    }

    public Integer countDebtApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDebtApplyIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countDebtApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,status  : " + uid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDebtApplyIdsByUidAndStatus", new Object[]{uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,status)  : " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getDebtApplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDebtApplyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countDebtApplyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getDebtApplyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getDebtApplyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Boolean addDebtApply(Order order, Long loanProductId, User user) throws ServiceException, ServiceDaoException {
        LoanProduct loanProduct = this.loanProductService.getObjectById(loanProductId);
        DebtApply debtApply = new DebtApply();
        Boolean result = false;
        BigDecimal money = order.getPriceTot().multiply(loanProduct.getRatio()).divide(new BigDecimal("100"), 3, 4);
        BigDecimal debtCount = order.getPriceTot().subtract(money);
        Long now = System.currentTimeMillis();
        debtApply.setUid(order.getUid());
        debtApply.setUserMobile(user.getMobile());
        debtApply.setUserName(user.getName());
        debtApply.setOrderID(order.getId());
        debtApply.setOrderNo(order.getOrderNo());
        debtApply.setTotal(order.getPriceTot());
        debtApply.setDebtCount(debtCount);
        debtApply.setRate(loanProduct.getRate());
        debtApply.setOverRate(loanProduct.getOverRate());
        debtApply.setStatus(DebtApply.STATUS_VERIFYING);
        debtApply.setType(DebtApply.TYPE_VERIFYING);
        debtApply.setOrderType(DebtApply.ORDER_TYPE_DEBT);
        debtApply.setVerifyAt(Long.valueOf(0L));
        debtApply.setRepayWay(DebtApply.REPAYWAY_1);
        debtApply.setSecondVerifyAt(Long.valueOf(0L));
        debtApply.setRepayLine(loanProduct.getRepayLine());
        debtApply.setAdditional(order.getAdditional());
        Long debtApplyId = this.insert(debtApply);
        log.info((Object)("now insert debtApply success and debtApplyId is " + debtApplyId));
        return result;
    }

    public DebtApply object2debtApply(Object[] rs) {
        DebtApply debtApply = new DebtApply();
        debtApply.setId(this.longValue(rs[0]));
        debtApply.setUid(this.longValue(rs[1]));
        debtApply.setUserMobile(this.stringValue(rs[2]));
        debtApply.setUserName(this.stringValue(rs[3]));
        debtApply.setOrderNo(this.stringValue(rs[4]));
        debtApply.setOrderID(this.longValue(rs[5]));
        debtApply.setTotal(this.bigDecimalValue(rs[6]));
        debtApply.setDebtCount(this.bigDecimalValue(rs[7]));
        debtApply.setRate(this.bigDecimalValue(rs[8]));
        debtApply.setOverRate(this.bigDecimalValue(rs[9]));
        debtApply.setRepayWay(this.intValue(rs[10]));
        debtApply.setReason(this.stringValue(rs[11]));
        debtApply.setStatus(this.intValue(rs[12]));
        debtApply.setType(this.intValue(rs[13]));
        debtApply.setOrderType(this.intValue(rs[14]));
        debtApply.setRepayLine(this.intValue(rs[15]));
        debtApply.setRepayTot(this.bigDecimalValue(rs[16]));
        debtApply.setOverAt(this.longValue(rs[17]));
        debtApply.setVerifyAt(this.longValue(rs[18]));
        debtApply.setSecondVerifyAt(this.longValue(rs[19]));
        debtApply.setVerifyBy(this.longValue(rs[20]));
        debtApply.setSecondVerifyBy(this.longValue(rs[21]));
        debtApply.setClearInte(this.bigDecimalValue(rs[22]));
        debtApply.setClearOverInte(this.bigDecimalValue(rs[23]));
        debtApply.setOverDayCount(this.bigDecimalValue(rs[24]));
        debtApply.setClearAt(this.longValue(rs[25]));
        debtApply.setCreateBy(this.longValue(rs[26]));
        debtApply.setUpdateBy(this.longValue(rs[27]));
        debtApply.setUpdateAt(this.longValue(rs[28]));
        debtApply.setCreateAt(this.longValue(rs[29]));
        debtApply.setDebtAt(this.longValue(rs[30]));
        debtApply.setAdditional(this.stringValue(rs[31]));
        return debtApply;
    }

    public Long longValue(Object rs) {
        if (null == rs) {
            return null;
        }
        return Long.valueOf(rs.toString());
    }

    public String stringValue(Object rs) {
        if (null == rs) {
            return null;
        }
        return rs.toString();
    }

    public BigDecimal bigDecimalValue(Object rs) {
        if (null == rs || "".equals(rs)) {
            return null;
        }
        return new BigDecimal(rs.toString());
    }

    public Integer intValue(Object rs) {
        if (null == rs) {
            return null;
        }
        return Integer.valueOf(rs.toString());
    }
}

