/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.RepayHistory;
import com.ptteng.wealth.finance.service.RepayHistoryService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepayHistoryServiceImpl
extends BaseDaoServiceImpl
implements RepayHistoryService {
    private static final Log log = LogFactory.getLog(RepayHistoryServiceImpl.class);

    public Long insert(RepayHistory repayHistory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + repayHistory));
        if (repayHistory == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        repayHistory.setCreateAt(Long.valueOf(currentTimeMillis));
        repayHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)repayHistory);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + repayHistory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RepayHistory> insertList(List<RepayHistory> repayHistoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (repayHistoryList == null ? "null" : Integer.valueOf(repayHistoryList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(repayHistoryList)) {
            return new ArrayList<RepayHistory>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RepayHistory repayHistory : repayHistoryList) {
            repayHistory.setCreateAt(Long.valueOf(currentTimeMillis));
            repayHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(repayHistoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + repayHistoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RepayHistory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RepayHistory repayHistory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (repayHistory == null ? "null" : repayHistory.getId())));
        boolean result = false;
        if (repayHistory == null) {
            return true;
        }
        repayHistory.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)repayHistory);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + repayHistory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + repayHistory));
        }
        return result;
    }

    public boolean updateList(List<RepayHistory> repayHistoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (repayHistoryList == null ? "null" : Integer.valueOf(repayHistoryList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(repayHistoryList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RepayHistory repayHistory : repayHistoryList) {
            repayHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(repayHistoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + repayHistoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + repayHistoryList.size()));
        return result;
    }

    public RepayHistory getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RepayHistory repayHistory = null;
        if (id == null) {
            return repayHistory;
        }
        try {
            repayHistory = (RepayHistory)this.dao.get(RepayHistory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return repayHistory;
    }

    public List<RepayHistory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List repayHistory = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RepayHistory>();
        }
        try {
            repayHistory = this.dao.getList(RepayHistory.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (repayHistory == null ? "null" : Integer.valueOf(repayHistory.size()))));
        return repayHistory;
    }

    public List<Long> getRepayHistoryIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRepayHistoryIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getRepayHistoryIdsByMobile(String mobile, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by mobile,start,limit  : " + mobile + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRepayHistoryIdsByMobile", new Object[]{mobile}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by mobile,start,limit)  : " + mobile + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getRepayHistoryIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderNo  : " + orderNo));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getRepayHistoryIdByOrderNo", new Object[]{orderNo});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderNo  : " + orderNo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getRepayHistoryIdByNumber(String number) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by number  : " + number));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getRepayHistoryIdByNumber", new Object[]{number});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by number  : " + number));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countRepayHistoryIdsByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by name  : " + name));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRepayHistoryIdsByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by name)  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countRepayHistoryIdsByMobile(String mobile) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by mobile  : " + mobile));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRepayHistoryIdsByMobile", new Object[]{mobile});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by mobile)  : " + mobile));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getRepayHistoryIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRepayHistoryIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRepayHistoryIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRepayHistoryIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRepayHistoryIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

