package com.ptteng.wealth.finance.service.impl.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.config.helper.GroupHelper;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.id.dao.SequenceDao;
import com.gemantic.dal.id.util.IdCenterHelper;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.SwapDao;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Component("UserAccountRelationServiceImpl")
public class UserAccountRelationServiceImpl extends BaseDaoServiceImpl implements UserAccountRelationService {


    private static final Log log = LogFactory.getLog(UserAccountRelationServiceImpl.class);
    protected SwapDao swapDao = new SwapDao(GroupHelper.getDataSource("wealth_finance"));


    @Override
    public Long insert(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userAccountRelation);
        if (userAccountRelation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userAccountRelation.setCreateAt(currentTimeMillis);
        userAccountRelation.setUpdateAt(currentTimeMillis);
        Long result = null;
        try {
            result = (Long) dao.save(userAccountRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userAccountRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserAccountRelation> insertList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userAccountRelationList == null ? "null" : userAccountRelationList.size()));

        List<UserAccountRelation> resultList = null;

        if (CollectionUtils.isEmpty(userAccountRelationList)) {
            return new ArrayList<UserAccountRelation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserAccountRelation userAccountRelation : userAccountRelationList) {
            userAccountRelation.setCreateAt(currentTimeMillis);
            userAccountRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserAccountRelation>) dao.batchSave(userAccountRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userAccountRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserAccountRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userAccountRelation == null ? "null" : userAccountRelation.getId()));

        boolean result = false;

        if (userAccountRelation == null) {
            return true;
        }

        userAccountRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userAccountRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userAccountRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userAccountRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userAccountRelationList == null ? "null" : userAccountRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userAccountRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserAccountRelation userAccountRelation : userAccountRelationList) {
            userAccountRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userAccountRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userAccountRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userAccountRelationList.size());

        return result;
    }


    @Override
    public UserAccountRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserAccountRelation userAccountRelation = null;

        if (id == null) {
            return userAccountRelation;
        }

        try {
            userAccountRelation = (UserAccountRelation) dao.get(UserAccountRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userAccountRelation;
    }


    @Override
    public List<UserAccountRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserAccountRelation> userAccountRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserAccountRelation>();
        }

        try {
            userAccountRelation = (List<UserAccountRelation>) dao.getList(UserAccountRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userAccountRelation == null ? "null" : userAccountRelation.size()));

        return userAccountRelation;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserAccountRelationIdByUserIdAndAccountId(Long userId, Long accountId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by userId,accountId  : " + userId + " , " + accountId);
        }
        Long id = null;
        try {
            id = (Long) dao.getMapping("getUserAccountRelationIdByUserIdAndAccountId", new Object[]{userId, accountId});
        } catch (DaoException e) {
            log.error(" get id wrong by userId,accountId  : " + userId + " , " + accountId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }

    @Override
    public Long getUserAccountRelationIdByUserIdAndAccountCode(Long userId, String accountCode) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by userId,accountCode  : " + userId + " , " + accountCode);
        }
        Long id = null;
        try {
            id = (Long) dao.getMapping("getUserAccountRelationIdByUserIdAndAccountCode", new Object[]{userId, accountCode});
        } catch (DaoException e) {
            log.error(" get id wrong by userId,accountCode  : " + userId + " , " + accountCode);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserAccountRelationIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by userId,start,limit  : " + userId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = dao.getIdList("getUserAccountRelationIdsByUserId", new Object[]{userId}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by userId,start,limit)  : " + userId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserAccountRelationIdsByUserId(Long userId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count ids by userId  : " + userId);
        }
        Integer count = null;
        try {
            count = dao.count("getUserAccountRelationIdsByUserId", new Object[]{userId});

        } catch (DaoException e) {
            log.error(" count ids  wrong by userId)  : " + userId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }


    @Override
    public List<Long> getUserAccountRelationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = dao.getIdList("getUserAccountRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserAccountRelationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserAccountRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserAccountRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    /**
     *  创建调账记录
     */
    @Override
    public int swapMoney(Long fromId, Long toId, Double money, String serialNo, Long mid, String comments) throws ServiceException, ServiceDaoException {
        Map map = swapDao.getResult(fromId, toId, money, serialNo, mid, comments, System.currentTimeMillis());
        log.info("swap money map : " + map.toString() + " and errorcode : " + map.get("errorcode").toString());
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    /**
     *  执行真正的调账操作
     */
    @Override
    public int execMoney(Long recordId, Long userId) throws ServiceException, ServiceDaoException {
        Map map = swapDao.execResult(recordId, userId, System.currentTimeMillis());
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    /**
     * 创建上账操作
     */
    @Override
    public int addResult(Long acountid, Double amount, String serialNo, Integer mtype, Long mid, Long postLine, Integer needCheck,
                         Integer receiveCheck, String fromParty, String fromBank, String fromAt, String comment) throws ServiceException, ServiceDaoException {
        log.info(acountid + "  " + amount + " " + serialNo + "  " + mtype + "  " + mid + "  " + postLine + "  " + needCheck + "  "
                + receiveCheck + "  " + fromParty + "  " + fromBank + "  " + fromAt + "  " + comment);
        Map map = swapDao.addResult(acountid, amount, serialNo, mtype, mid, System.currentTimeMillis(), postLine, needCheck, receiveCheck,
                fromParty, fromBank, fromAt, comment);
        log.info("add result map : " + map.toString() + " and errorcode : " + map.get("errorcode").toString());
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    /**
     * 实际执行上账操作
     */
    @Override
    public int addExec(Long recordId, Long mid) throws ServiceException, ServiceDaoException {
        Map map = swapDao.addExec(recordId, mid, System.currentTimeMillis());
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    @Override
    public int payOrder(Long orderId, Long userAccountId,Integer payType) throws ServiceException, ServiceDaoException {
        log.info("payOrder orderId : " + orderId + " userAccountId : " + userAccountId + " payType : " + payType);
        Map map = swapDao.payorder(orderId, userAccountId,payType);
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    @Override
    public int payDeposit(Long userAccountId, Double paymoney,Double debtCount, Long debtApplyId, Long uid, Long orderId,Long overAt)  {
        log.info(" payDeposit userAccountId: "+userAccountId+" paymoney: "+paymoney +" debtCount: "+debtCount+" debtApplyId: "+debtApplyId+" uid: "+uid+" orderId: "+orderId+" overAt: "+overAt);
        Map map = swapDao.paydeposit(userAccountId, paymoney,debtCount, debtApplyId, uid, orderId,overAt);
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    @Override
    public int payDepositdaixiao(Double debtCount, Long debtApplyId, Long uid, Long orderId,Long overAt)  {
        log.info("payDepositdaixiao  DebtCount: "+debtCount+" debtApplyId: "+debtApplyId+" uid: "+uid+" orderId: "+orderId+" overAt: "+overAt);
        Map map = swapDao.paydepositdaixiao(debtCount, debtApplyId, uid, orderId,overAt);
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    @Override
    public int shexiaoKL(Long userAccountId, Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        Map map = swapDao.shexiaoKL(userAccountId, repayTot, clearInte, clearOverInte, overDayCount, clearAt, loanApplyId, orderId, currenttime);
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    @Override
    public int shexiaoDX(Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        log.info("shexiaoDX repayTot : " + repayTot + " clearInte : " + clearInte + " clearOverInte : " + clearOverInte + " overDayCount : " + overDayCount +
        " clearAt : " + clearAt + " loanApplyId : " + loanApplyId + " orderId : " + orderId + " currenttime : " + currenttime);
        Map map = swapDao.shexiaoDX(repayTot, clearInte, clearOverInte, overDayCount, clearAt, loanApplyId, orderId, currenttime);
        String errocode = (String) map.get("errorcode");
        log.info(" error code : " + errocode);
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

}

