package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.RepayHistory;
import com.ptteng.wealth.finance.service.RepayHistoryService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class RepayHistoryServiceImpl extends BaseDaoServiceImpl implements RepayHistoryService {


    private static final Log log = LogFactory.getLog(RepayHistoryServiceImpl.class);


    @Override
    public Long insert(RepayHistory repayHistory) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + repayHistory);

        if (repayHistory == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        repayHistory.setCreateAt(currentTimeMillis);
        repayHistory.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(repayHistory);
        } catch (DaoException e) {
            log.error(" insert wrong : " + repayHistory);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<RepayHistory> insertList(List<RepayHistory> repayHistoryList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (repayHistoryList == null ? "null" : repayHistoryList.size()));

        List<RepayHistory> resultList = null;

        if (CollectionUtils.isEmpty(repayHistoryList)) {
            return new ArrayList<RepayHistory>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (RepayHistory repayHistory : repayHistoryList) {
            repayHistory.setCreateAt(currentTimeMillis);
            repayHistory.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<RepayHistory>) dao.batchSave(repayHistoryList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + repayHistoryList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(RepayHistory.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(RepayHistory repayHistory) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (repayHistory == null ? "null" : repayHistory.getId()));

        boolean result = false;

        if (repayHistory == null) {
            return true;
        }

        repayHistory.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(repayHistory);
        } catch (DaoException e) {
            log.error(" update wrong : " + repayHistory);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + repayHistory);
        }
        return result;
    }


    @Override
    public boolean updateList(List<RepayHistory> repayHistoryList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (repayHistoryList == null ? "null" : repayHistoryList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(repayHistoryList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (RepayHistory repayHistory : repayHistoryList) {
            repayHistory.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(repayHistoryList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + repayHistoryList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + repayHistoryList.size());

        return result;
    }


    @Override
    public RepayHistory getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        RepayHistory repayHistory = null;

        if (id == null) {
            return repayHistory;
        }

        try {
            repayHistory = (RepayHistory) dao.get(RepayHistory.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return repayHistory;
    }


    @Override
    public List<RepayHistory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<RepayHistory> repayHistory = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RepayHistory>();
        }

        try {
            repayHistory = (List<RepayHistory>) dao.getList(RepayHistory.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (repayHistory == null ? "null" : repayHistory.size()));

        return repayHistory;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getRepayHistoryIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getRepayHistoryIdsByName", new Object[]{name}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getRepayHistoryIdsByMobile(String mobile, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by mobile,start,limit  : " + mobile + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getRepayHistoryIdsByMobile", new Object[]{mobile}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by mobile,start,limit)  : " + mobile + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getRepayHistoryIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by orderNo  : " + orderNo);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getRepayHistoryIdByOrderNo", new Object[]{orderNo});
        } catch (DaoException e) {
            log.error(" get id wrong by orderNo  : " + orderNo);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getRepayHistoryIdByNumber(String number) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by number  : " + number);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getRepayHistoryIdByNumber", new Object[]{number});
        } catch (DaoException e) {
            log.error(" get id wrong by number  : " + number);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countRepayHistoryIdsByName(String name) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by name  : " + name);
        }
        Integer count = null;


        try {

            count = dao.count("getRepayHistoryIdsByName", new Object[]{name});


        } catch (DaoException e) {
            log.error(" count ids  wrong by name)  : " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countRepayHistoryIdsByMobile(String mobile) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by mobile  : " + mobile);
        }
        Integer count = null;


        try {

            count = dao.count("getRepayHistoryIdsByMobile", new Object[]{mobile});


        } catch (DaoException e) {
            log.error(" count ids  wrong by mobile)  : " + mobile);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getRepayHistoryIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getRepayHistoryIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countRepayHistoryIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getRepayHistoryIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getRepayHistoryIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

