package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.CreditApply;
import com.ptteng.wealth.finance.service.CreditApplyService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class CreditApplyServiceImpl extends BaseDaoServiceImpl implements CreditApplyService {


    private static final Log log = LogFactory.getLog(CreditApplyServiceImpl.class);


    @Override
    public Long insert(CreditApply creditApply) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + creditApply);

        if (creditApply == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        creditApply.setCreateAt(currentTimeMillis);
        creditApply.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(creditApply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + creditApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<CreditApply> insertList(List<CreditApply> creditApplyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (creditApplyList == null ? "null" : creditApplyList.size()));

        List<CreditApply> resultList = null;

        if (CollectionUtils.isEmpty(creditApplyList)) {
            return new ArrayList<CreditApply>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (CreditApply creditApply : creditApplyList) {
            creditApply.setCreateAt(currentTimeMillis);
            creditApply.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<CreditApply>) dao.batchSave(creditApplyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + creditApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(CreditApply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(CreditApply creditApply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (creditApply == null ? "null" : creditApply.getId()));

        boolean result = false;

        if (creditApply == null) {
            return true;
        }

        creditApply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(creditApply);
        } catch (DaoException e) {
            log.error(" update wrong : " + creditApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + creditApply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<CreditApply> creditApplyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (creditApplyList == null ? "null" : creditApplyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(creditApplyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (CreditApply creditApply : creditApplyList) {
            creditApply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(creditApplyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + creditApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + creditApplyList.size());

        return result;
    }


    @Override
    public CreditApply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        CreditApply creditApply = null;

        if (id == null) {
            return creditApply;
        }

        try {
            creditApply = (CreditApply) dao.get(CreditApply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return creditApply;
    }


    @Override
    public List<CreditApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<CreditApply> creditApply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CreditApply>();
        }

        try {
            creditApply = (List<CreditApply>) dao.getList(CreditApply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (creditApply == null ? "null" : creditApply.size()));

        return creditApply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCreditApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCreditApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCreditApplyIdsByVerifyManager(String verifyManager, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by verifyManager,start,limit  : " + verifyManager + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCreditApplyIdsByVerifyManager", new Object[]{verifyManager}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by verifyManager,start,limit)  : " + verifyManager + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCreditApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCreditApplyIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCreditApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,status  : " + uid + " , " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getCreditApplyIdsByUidAndStatus", new Object[]{uid, status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,status)  : " + uid + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCreditApplyIdsByVerifyManager(String verifyManager) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by verifyManager  : " + verifyManager);
        }
        Integer count = null;


        try {

            count = dao.count("getCreditApplyIdsByVerifyManager", new Object[]{verifyManager});


        } catch (DaoException e) {
            log.error(" count ids  wrong by verifyManager)  : " + verifyManager);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCreditApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getCreditApplyIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getCreditApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCreditApplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countCreditApplyIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getCreditApplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getCreditApplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

