/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Bank;
import com.ptteng.wealth.finance.service.BankService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BankServiceImpl
extends BaseDaoServiceImpl
implements BankService {
    private static final Log log = LogFactory.getLog(BankServiceImpl.class);

    public Long insert(Bank bank) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + bank));
        if (bank == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        bank.setCreateAt(Long.valueOf(currentTimeMillis));
        bank.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)bank);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + bank));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Bank> insertList(List<Bank> bankList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (bankList == null ? "null" : Integer.valueOf(bankList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(bankList)) {
            return new ArrayList<Bank>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Bank bank : bankList) {
            bank.setCreateAt(Long.valueOf(currentTimeMillis));
            bank.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(bankList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + bankList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Bank.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Bank bank) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (bank == null ? "null" : bank.getId())));
        boolean result = false;
        if (bank == null) {
            return true;
        }
        bank.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)bank);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + bank));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + bank));
        }
        return result;
    }

    public boolean updateList(List<Bank> bankList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (bankList == null ? "null" : Integer.valueOf(bankList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(bankList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Bank bank : bankList) {
            bank.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(bankList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + bankList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + bankList.size()));
        return result;
    }

    public Bank getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Bank bank = null;
        if (id == null) {
            return bank;
        }
        try {
            bank = (Bank)this.dao.get(Bank.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return bank;
    }

    public List<Bank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List bank = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Bank>();
        }
        try {
            bank = this.dao.getList(Bank.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (bank == null ? "null" : Integer.valueOf(bank.size()))));
        return bank;
    }

    public Long getBankIdByCode(String bankCode) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get id by bankCode  : " + bankCode));
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getBankIdByCode", new Object[]{bankCode});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by bankCode  : " + bankCode));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getBankIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBankIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBankIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBankIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBankIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

