package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.ProductDaily;
import com.ptteng.wealth.finance.service.DrawService;
import com.ptteng.wealth.finance.service.InvestService;
import com.ptteng.wealth.finance.service.InvoiceService;
import com.ptteng.wealth.finance.service.ProductDailyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;


public class ProductDailyServiceImpl extends BaseDaoServiceImpl implements ProductDailyService {
	private InvestService investService;
	private DrawService drawService;
	private static final Log log = LogFactory.getLog(ProductDailyServiceImpl.class);



		   
		@Override
		public Long insert(ProductDaily productDaily)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + productDaily);

		if (productDaily == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		productDaily.setCreateAt(currentTimeMillis);
		productDaily.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(productDaily);
		} catch (DaoException e) {
			log.error(" insert wrong : " + productDaily);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ProductDaily> insertList(List<ProductDaily> productDailyList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (productDailyList == null ? "null" : productDailyList.size()));
      
		List<ProductDaily> resultList = null;

		if (CollectionUtils.isEmpty(productDailyList)) {
			return new ArrayList<ProductDaily>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductDaily productDaily : productDailyList) {
			productDaily.setCreateAt(currentTimeMillis);
			productDaily.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ProductDaily>) dao.batchSave(productDailyList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + productDailyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ProductDaily.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ProductDaily productDaily)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (productDaily == null ? "null" : productDaily.getId()));

		boolean result = false;

		if (productDaily == null) {
			return true;
		}

		productDaily.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(productDaily);
		} catch (DaoException e) {
			log.error(" update wrong : " + productDaily);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + productDaily);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProductDaily> productDailyList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (productDailyList == null ? "null" : productDailyList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(productDailyList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductDaily productDaily : productDailyList) {
			productDaily.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(productDailyList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + productDailyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + productDailyList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ProductDaily getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ProductDaily productDaily = null;

		if (id == null) {
			return productDaily;
		}

		try {
			productDaily = (ProductDaily) dao.get(ProductDaily.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return productDaily;		
		}	
		  
    	   
		@Override
		public List<ProductDaily> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ProductDaily> productDaily = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ProductDaily>();
		}

		try {
			productDaily = (List<ProductDaily>) dao.getList(ProductDaily.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (productDaily == null ? "null" : productDaily.size()));
    
		return productDaily;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getProductDailyIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProductDailyIdsAll", new Object[]{}, start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProductDailyIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProductDailyIdsAll", new Object[]{});
		} catch (DaoException e) {
			log.error(" count by getProductDailyIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	public InvestService getInvestService() {
		return investService;
	}

	public void setInvestService(InvestService investService) {
		this.investService = investService;
	}

	public DrawService getDrawService() {
		return drawService;
	}

	public void setDrawService(DrawService drawService) {
		this.drawService = drawService;
	}

	public void addStatisticsDaily(Long uid,Long pid,BigDecimal amount,Integer type) throws ServiceException, ServiceDaoException {
		log.info(" uid = "+uid+" pid = "+pid+" amount = "+amount+" type = "+type);
		//查出日统计的最新一一条数据
		List<Long> productDailyIds =  this.getProductDailyIds(0, 1);
		log.info(" history ids = "+productDailyIds.size());
		Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
		log.info(" today is = "+getDate(staticAt));


		if(ProductDaily.INVEST.equals(type)){
			//统计购买
			log.info(" invest ");
			//查询用户购买此产品的记录
			List<Long> investIds = investService.getInvestIdsByUidAndPid(uid, pid, 0, 1);
			log.info(" user "+uid+" history investIds is = "+investIds);

			//如果日统计有数据
			if(productDailyIds.size()>0){
				log.info(" productDailyIds size >0 ");
				//日统计有数据，找出最新的那条数据，查询他的统计时间，跟现在的时间做对比
				ProductDaily productDaily = this.getObjectById(productDailyIds.get(0));
				if(staticAt.equals(productDaily.getStaticAt())){
					log.info(" staticAt is today  ");
					//今天已有数据,修改
					//判断该用户是否已购买过

					if(investIds.size()>0){
						log.info(" investIds size = 0 ");
						//已经购买过，购买总人数不加1
					}else{
						log.info(" investIds size > 0 ");
						productDaily.setBuyPersonSum(productDaily.getBuyPersonSum().add(new BigDecimal("1")));
					}

					productDaily.setBuyCount(productDaily.getBuyCount().add(new BigDecimal("1")));
					productDaily.setBuySumAmount(productDaily.getBuySumAmount().add(amount));
					this.update(productDaily);
				}else{
					log.info(" staticAt is not today  ");
					//今天还没数据,新增数据
					ProductDaily productDaily1 = new ProductDaily();
					productDaily1.setProductId(pid);
					productDaily1.setStaticAt(staticAt);
					if(investIds.size()>0){
						log.info(" investIds size = 0 ");
						//已经购买过，购买总人数不加1
					}else {
						log.info(" investIds size > 0 ");
						productDaily1.setBuyPersonSum(new BigDecimal("1"));
					}
					productDaily1.setBuyCount(new BigDecimal("1"));
					productDaily1.setBuySumAmount(amount);
					productDaily1.setCreateBy(uid);
					productDaily1.setUpdateBy(uid);
					Long statisticsId = this.insert(productDaily1);
					log.info(" statisticsId = "+statisticsId);
				}

			}else {
				//日统计还没一条数据
				log.info(" productDailyIds size = 0 ");
				ProductDaily productDaily1 = new ProductDaily();
				productDaily1.setProductId(pid);
				productDaily1.setStaticAt(staticAt);
				if(!(investIds.size()>0)){
					productDaily1.setBuyPersonSum(new BigDecimal("1"));
				}
				productDaily1.setBuyCount(new BigDecimal("1"));
				productDaily1.setBuySumAmount(amount);
				productDaily1.setCreateBy(uid);
				productDaily1.setUpdateBy(uid);
				Long statisticsId = this.insert(productDaily1);
				log.info(" statisticsId = "+statisticsId);

			}

		}else {
			log.info(" withdrwal ");
			List<Long> drawIds = drawService.getDrawIdsByUidAndPid(uid, pid, 0, 1);
			log.info(" user "+uid+" history drawIds is = "+drawIds);
			Map<String, Object> params2 = new HashMap();

			if(productDailyIds.size()>0){
				log.info(" productDailyIds size >0 ");
				//有
				ProductDaily productDaily = this.getObjectById(productDailyIds.get(0));
				if(staticAt.equals(productDaily.getStaticAt())){
					log.info(" staticAt is today  ");
					//今天已有数据,修改
					//判断该用户是否已赎回过

					if(drawIds.size()>0){
						log.info(" drawIds size = 0 ");
						//已经赎回过，赎回总人数不加1
					} else {
						log.info(" drawIds size >0 ");
						productDaily.setWithdrawalPersonSum(productDaily.getWithdrawalPersonSum().add(new BigDecimal("1")));
					}
					log.info("  withdrawalPersonSum = "+productDaily.getWithdrawalPersonSum());

					productDaily.setWithdrawalCount(productDaily.getWithdrawalCount().add(new BigDecimal("1")));
					productDaily.setWithdrawalAmount(productDaily.getWithdrawalAmount().add(amount));
					this.update(productDaily);
				}else{
					log.info(" staticAt is not today  ");
					//今天还没数据,新增数据
					ProductDaily productDaily1 = new ProductDaily();
					productDaily1.setProductId(pid);
					productDaily1.setStaticAt(staticAt);
					if(!(drawIds.size() > 0)) {
						productDaily1.setWithdrawalPersonSum(new BigDecimal("1"));
					}

					log.info("  withdrawalPersonSum = "+productDaily1.getWithdrawalPersonSum());

					productDaily1.setWithdrawalCount(new BigDecimal("1"));
					productDaily1.setWithdrawalAmount(amount);
					productDaily1.setCreateBy(uid);
					productDaily1.setUpdateBy(uid);
					Long statisticsId = this.insert(productDaily1);
					log.info(" statisticsId = "+statisticsId);
				}

			}else {
				log.info(" productDailyIds size = 0 ");
				//今天还没数据
				ProductDaily productDaily1 = new ProductDaily();
				productDaily1.setProductId(pid);
				productDaily1.setStaticAt(staticAt);
				if(!(drawIds.size()>0)){
					productDaily1.setWithdrawalPersonSum(new BigDecimal("1"));
				}
				log.info("  withdrawalPersonSum = "+productDaily1.getWithdrawalPersonSum());

				productDaily1.setWithdrawalCount(new BigDecimal("1"));
				productDaily1.setWithdrawalAmount(amount);
				productDaily1.setCreateBy(uid);
				productDaily1.setUpdateBy(uid);
				Long statisticsId = this.insert(productDaily1);
				log.info(" statisticsId = "+statisticsId);

			}
		}



	}
	public static String getDate(Long time){
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
		String date = "";
		if(null != time){
			date = dateFormat.format(new Date(time));
		}
		return  date;
	}
}

