package com.ptteng.wealth.finance.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Invest;
import com.ptteng.wealth.finance.service.InvestService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class InvestServiceImpl extends BaseDaoServiceImpl implements InvestService {

 

	private static final Log log = LogFactory.getLog(InvestServiceImpl.class);



		   
		@Override
		public Long insert(Invest invest)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + invest);

		if (invest == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		invest.setCreateAt(currentTimeMillis);
		invest.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(invest);
		} catch (DaoException e) {
			log.error(" insert wrong : " + invest);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Invest> insertList(List<Invest> investList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (investList == null ? "null" : investList.size()));
      
		List<Invest> resultList = null;

		if (CollectionUtils.isEmpty(investList)) {
			return new ArrayList<Invest>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Invest invest : investList) {
			invest.setCreateAt(currentTimeMillis);
			invest.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Invest>) dao.batchSave(investList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + investList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Invest.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Invest invest)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (invest == null ? "null" : invest.getId()));

		boolean result = false;

		if (invest == null) {
			return true;
		}

		invest.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(invest);
		} catch (DaoException e) {
			log.error(" update wrong : " + invest);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + invest);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Invest> investList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (investList == null ? "null" : investList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(investList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Invest invest : investList) {
			invest.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(investList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + investList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + investList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Invest getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Invest invest = null;

		if (id == null) {
			return invest;
		}

		try {
			invest = (Invest) dao.get(Invest.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return invest;		
		}	
		  
    	   
		@Override
		public List<Invest> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Invest> invest = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Invest>();
		}

		try {
			invest = (List<Invest>) dao.getList(Invest.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (invest == null ? "null" : invest.size()));
    
		return invest;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getInvestIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getInvestIdsByUidAndStatus", new Object[] { uid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit)  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getInvestIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getInvestIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getInvestIdsByUidAndPid(Long uid,Long pid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,pid,start,limit  : " + uid+" , "+pid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getInvestIdsByUidAndPid", new Object[] { uid,pid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,pid,start,limit)  : " + uid+" , "+pid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countInvestIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,status  : " + uid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getInvestIdsByUidAndStatus", new Object[] { uid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,status)  : " + uid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countInvestIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getInvestIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countInvestIdsByUidAndPid(Long uid,Long pid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,pid  : " + uid+" , "+pid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getInvestIdsByUidAndPid", new Object[] { uid,pid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,pid)  : " + uid+" , "+pid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getInvestIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getInvestIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countInvestIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getInvestIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getInvestIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	@Override
	public Long addInvest(Long uid, Long pid,Integer paymentType, BigDecimal amount, String bankName, String name, String mobile,
							 String cardNo, Long inteAt) throws ServiceException, ServiceDaoException {
		Long id =  0L;
		try {

			Invest invest = new Invest();
			invest.setUid(uid);
			invest.setPid(pid);
			invest.setPaymentType(paymentType);
			invest.setName(name);
			invest.setCardNo(cardNo);
			invest.setStatus(Invest.STATUS_COMPLETE);
			invest.setAmount(amount);
			invest.setBankName(bankName);
			invest.setInteAt(inteAt);
			log.info("invest record : " + invest);
			id = insert(invest);

		} catch (Exception e) {
			log.error(" count by getInvestIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" insert invest wrong");
		}
		return id;
	}

}

