package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.service.FundService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class FundServiceImpl extends BaseDaoServiceImpl implements FundService {


    private static final Log log = LogFactory.getLog(FundServiceImpl.class);


    @Override
    public Long insert(Fund fund) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + fund);

        if (fund == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        fund.setCreateAt(currentTimeMillis);
        fund.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(fund);
        } catch (DaoException e) {
            log.error(" insert wrong : " + fund);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Fund> insertList(List<Fund> fundList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (fundList == null ? "null" : fundList.size()));

        List<Fund> resultList = null;

        if (CollectionUtils.isEmpty(fundList)) {
            return new ArrayList<Fund>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Fund fund : fundList) {
            fund.setCreateAt(currentTimeMillis);
            fund.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Fund>) dao.batchSave(fundList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + fundList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Fund.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Fund fund) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (fund == null ? "null" : fund.getId()));

        boolean result = false;

        if (fund == null) {
            return true;
        }

        fund.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(fund);
        } catch (DaoException e) {
            log.error(" update wrong : " + fund);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + fund);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Fund> fundList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (fundList == null ? "null" : fundList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(fundList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Fund fund : fundList) {
            fund.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(fundList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + fundList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + fundList.size());

        return result;
    }


    @Override
    public Fund getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Fund fund = null;

        if (id == null) {
            return fund;
        }

        try {
            fund = (Fund) dao.get(Fund.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return fund;
    }


    @Override
    public List<Fund> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Fund> fund = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Fund>();
        }

        try {
            fund = (List<Fund>) dao.getList(Fund.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (fund == null ? "null" : fund.size()));

        return fund;
    }


    @Override
    public List<Long> getFundIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getFundIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countFundIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getFundIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getFundIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

