package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.CashApply;
import com.ptteng.wealth.finance.service.CashApplyService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class CashApplyServiceImpl extends BaseDaoServiceImpl implements CashApplyService {


    private static final Log log = LogFactory.getLog(CashApplyServiceImpl.class);


    @Override
    public Long insert(CashApply cashApply) throws ServiceException, ServiceDaoException {
        log.info(" insert data : " + cashApply);
        if (cashApply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        cashApply.setCreateAt(currentTimeMillis);
        cashApply.setUpdateAt(currentTimeMillis);
        Long result = null;
        try {
            result = (Long) dao.save(cashApply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + cashApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info(" insert data success : " + result);
        return result;
    }


    @Override
    public List<CashApply> insertList(List<CashApply> cashApplyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (cashApplyList == null ? "null" : cashApplyList.size()));

        List<CashApply> resultList = null;

        if (CollectionUtils.isEmpty(cashApplyList)) {
            return new ArrayList<CashApply>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CashApply cashApply : cashApplyList) {
            cashApply.setCreateAt(currentTimeMillis);
            cashApply.setUpdateAt(currentTimeMillis);
        }
        try {
            resultList = (List<CashApply>) dao.batchSave(cashApplyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + cashApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
        return resultList;
    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = dao.delete(CashApply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info(" delete data success : " + id);
        return result;

    }


    @Override
    public boolean update(CashApply cashApply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (cashApply == null ? "null" : cashApply.getId()));

        boolean result = false;

        if (cashApply == null) {
            return true;
        }

        cashApply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(cashApply);
        } catch (DaoException e) {
            log.error(" update wrong : " + cashApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + cashApply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<CashApply> cashApplyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (cashApplyList == null ? "null" : cashApplyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(cashApplyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (CashApply cashApply : cashApplyList) {
            cashApply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(cashApplyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + cashApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + cashApplyList.size());

        return result;
    }


    @Override
    public CashApply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        CashApply cashApply = null;

        if (id == null) {
            return cashApply;
        }

        try {
            cashApply = (CashApply) dao.get(CashApply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return cashApply;
    }


    @Override
    public List<CashApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<CashApply> cashApply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CashApply>();
        }

        try {
            cashApply = (List<CashApply>) dao.getList(CashApply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (cashApply == null ? "null" : cashApply.size()));

        return cashApply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCashApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCashApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCashApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCashApplyIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCashApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,status  : " + uid + " , " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getCashApplyIdsByUidAndStatus", new Object[]{uid, status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,status)  : " + uid + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCashApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getCashApplyIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getCashApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getCashApplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countCashApplyIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getCashApplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getCashApplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

