package com.ptteng.wealth.finance;

import com.gemantic.dal.id.dao.SequenceDao;
import com.gemantic.dal.id.util.IdCenterHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import java.util.Map;

/**
 * Created by arthur on 16/7/20.
 */
public class SwapDao {
    private static final Log log = LogFactory.getLog(SequenceDao.class);

    protected DataSource dataSource;
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected SimpleJdbcCall swapproc;       //生成调账记录
    protected SimpleJdbcCall execproc;      //执行调账操作
    protected SimpleJdbcCall addproc;       //生成上账记录
    protected SimpleJdbcCall addprocexec;   //实际执行上账操作
    protected SimpleJdbcCall payorderexec ; //支付订单操作
    protected SimpleJdbcCall paydepositexec ;  //开磷账户支付保证金
    protected SimpleJdbcCall paydepositdaixiaoexec; //代销账户缴纳保证金成功后设置状态
    protected SimpleJdbcCall repayshexiaodaixiaoexec;   //赊销还款的代销支付
    protected SimpleJdbcCall repayshexiaoexec;         // 赊销还款的开磷支付


    public SwapDao(DataSource db) {
        dataSource = db;
        simpleJdbcTemplate = new SimpleJdbcTemplate(this.dataSource);

        swapproc = (new SimpleJdbcCall(this.dataSource)).withProcedureName("swap_money")
                             .useInParameterNames(new String[]{"fromid","toid","amount","serialNo","mid","comments","currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        execproc = (new SimpleJdbcCall(this.dataSource)).withProcedureName("execute_change")
                .useInParameterNames(new String[]{"recordid","mid","currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        addproc = (new SimpleJdbcCall(this.dataSource)).withProcedureName("add_money_record")
                .useInParameterNames(new String[]{"acountid","amount","serialNo","mtype","mid","currenttime", "postLine", "needCheck", "receiveCheck",
                        "fromParty", "fromBank", "fromAt", "comments"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        addprocexec =(new SimpleJdbcCall(this.dataSource)).withProcedureName("add_money_exec")
                .useInParameterNames(new String[]{"recordid","mid","currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        payorderexec = (new SimpleJdbcCall(this.dataSource)).withProcedureName("pay_order")
                .useInParameterNames(new String[]{"orderId","payType","userAccountId","currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        paydepositexec = (new SimpleJdbcCall(this.dataSource)).withProcedureName("pay_deposit")
                .useInParameterNames(new String[]{"userAccountId","paymoney","debtCount","debtApplyId","uid","orderId","currenttime","overattime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        paydepositdaixiaoexec = (new SimpleJdbcCall(this.dataSource)).withProcedureName("pay_deposit_daixiao")
                .useInParameterNames(new String[]{"debtApplyId","debtCount","uid","orderId","currenttime","overattime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        repayshexiaodaixiaoexec =(new SimpleJdbcCall(this.dataSource)).withProcedureName("pay_shexiao_daixiao")
                .useInParameterNames(new String[]{"repayTot","clearInte","clearOverInte","overDayCount","clearAt","loanApplyId","orderId","currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        repayshexiaoexec=(new SimpleJdbcCall(this.dataSource)).withProcedureName("pay_shexiao")
                .useInParameterNames(new String[]{"userAccountId","repayTot","clearInte","clearOverInte","overDayCount","clearAt","loanApplyId","orderId","currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
    }

    //赊销付款用开磷账户
    public Map  shexiaoKL(Long userAccountId,Double repayTot,Double clearInte, Double clearOverInte,Double overDayCount, Long clearAt,Long loanApplyId,Long orderId,Long currenttime) {
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("userAccountId", userAccountId)
                .addValue("repayTot",repayTot )
                .addValue("clearInte",clearInte )
                .addValue("clearOverInte",clearOverInte )
                .addValue("overDayCount",overDayCount)
                .addValue("clearAt",clearAt)
                .addValue("loanApplyId", loanApplyId)
                .addValue("orderId",orderId )
                .addValue("currenttime", currenttime);

        Map map = null;
        try {
            map = repayshexiaoexec.execute(params);
        } catch (Exception var5) {
            var5.printStackTrace(System.out);
        }

        return map;
    }

    //赊销付款代销支付
    public Map  shexiaoDX(Double repayTot,Double clearInte, Double clearOverInte,Double overDayCount, Long clearAt,Long loanApplyId,Long orderId,Long currenttime) {
        log.info(" shexiaoDX DAO: repayTot:  "+repayTot+"  clearInte: "+clearInte +"  clearOverInte: "+clearOverInte+"  overDayCount: "+overDayCount+" clearAt: "
                +clearAt+" loanApplyId: "+loanApplyId+" orderId: "+orderId+" currenttime: "+currenttime );
        MapSqlParameterSource params = (new MapSqlParameterSource())
                .addValue("repayTot",repayTot )
                .addValue("clearInte",clearInte )
                .addValue("clearOverInte",clearOverInte )
                .addValue("overDayCount",overDayCount)
                .addValue("clearAt",clearAt)
                .addValue("loanApplyId", loanApplyId)
                .addValue("orderId",orderId )
                .addValue("currenttime", currenttime);

        Map map = null;
        try {
            map = repayshexiaodaixiaoexec.execute(params);
        } catch (Exception var5) {
            var5.printStackTrace(System.out);
        }

        return map;
    }



    //代销账户缴纳保证金成功后设置状态
    public Map  paydepositdaixiao(Double debtCount,Long debtApplyId,Long uid,Long  orderId,Long overAt) {
        log.info(" PAY Deposit DaiXiao DAO: debtCount:  "+debtCount+"  debtApplyId: "+debtApplyId +"  uid: "+uid+"  orderId: "+orderId );
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("debtCount", debtCount)
                                                                    .addValue("debtApplyId", debtApplyId)
                                                                    .addValue("uid", uid)
                                                                    .addValue("orderId", orderId)
                                                                    .addValue("currenttime", System.currentTimeMillis())
                                                                    .addValue("overattime",overAt);

        Map map = null;
        try {
            map = paydepositdaixiaoexec.execute(params);
        } catch (Exception var5) {
            var5.printStackTrace(System.out);
        }

        return map;
    }

    //缴纳保证金
    public Map  paydeposit(Long userAccountId,Double paymoney,Double debtCount,Long debtApplyId,Long uid,Long  orderId,Long overAt) {
        log.info(" PAY Deposit  DAO: userAccountId: "+userAccountId+" paymoney: "+paymoney+" debtApplyId: "+debtApplyId +" uid: "+uid+" orderId: "+orderId );
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("userAccountId", userAccountId)
                .addValue("paymoney", paymoney)
                .addValue("debtCount",debtCount)
                .addValue("debtApplyId", debtApplyId)
                .addValue("uid",uid)
                .addValue("orderId",orderId)
                .addValue("currenttime", System.currentTimeMillis())
                .addValue("overattime",overAt);
        Map map = null;
        try {
            map = paydepositexec.execute(params);
        } catch (Exception var5) {
            log.warn("Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    //支付订单操作  -- 开磷账户支付
    public Map  payorder(Long  orderId,Long userAccountId,Integer payType) {
        log.info(" PAYORDER DAO: orderId: "+orderId+" userAccountId: "+userAccountId);
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("orderId", orderId)
                .addValue("payType",payType)
                .addValue("userAccountId", userAccountId)
                .addValue("currenttime", System.currentTimeMillis());
        Map map = null;
        try {
            map = payorderexec.execute(params);
        } catch (Exception var5) {
            log.warn("Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    //实际执行调账操作
    public Map  execResult(Long  recordId,Long mid,Long currentTime) {
        log.info(" SWAP DAO: recordId: "+recordId+" mid: "+mid+"  currentTime: "+currentTime);
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("recordid", recordId)
                                                                    .addValue("mid", mid)
                                                                    .addValue("currenttime", currentTime);
        Map map = null;
        try {
            map = this.execproc.execute(params);
        } catch (Exception var5) {
            log.warn("Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    //生成调账的操作记录
    public Map  getResult(Long fromId,Long toId,Double amount,String serialNo,Long mid,String comments,Long currentTime) {
        log.info(" SWAP DAO: fromId: "+fromId+" toId: "+toId+"  amount: "+amount);
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("fromid", fromId)
                                                                    .addValue("toid",toId)
                                                                    .addValue("amount",amount)
                                                                    .addValue("serialNo",serialNo)
                                                                    .addValue("mid",mid)
                                                                    .addValue("comments",comments)
                                                                    .addValue("currenttime", currentTime);
        Map map = null;
        try {
            map = this.swapproc.execute(params);
        } catch (Exception var5) {
            log.warn("Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    //实际执行上账操作
    public Map  addExec(Long  recordId,Long mid,Long currentTime) {
        log.info(" ADD EXEC DAO: recordId: "+recordId+" mid: "+mid+"  currentTime: "+currentTime);
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("recordid", recordId)
                                                                    .addValue("mid", mid)
                                                                    .addValue("currenttime", currentTime);
        Map map = null;
        try {
            map = addprocexec.execute(params);
        } catch (Exception var5) {
            log.warn("Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    //创建上账操作记录
    public Map addResult(Long acountid,Double amount,String serialNo,Integer mtype,Long mid,Long currentTime,Long postLine, Integer needCheck,
                         Integer receiveCheck, String fromParty, String fromBank, String fromAt, String comment) {
        log.info(" ADD DAO: acountid: "+acountid+"amount: "+amount+"  serialNo : "+serialNo+" mtype: "+mtype+" mid: "+mid+"  currentTime: "+currentTime
        +" postLine: "+postLine+" needCheck: "+needCheck+" receiveCheck: "+receiveCheck+" fromParty: "+fromParty+" fromBank: "+fromBank+" fromAt: "
        +fromAt+" comments: "+comment);
        MapSqlParameterSource params = (new MapSqlParameterSource()).addValue("acountid", acountid)
                .addValue("amount", amount)
                .addValue("serialNo", serialNo)
                .addValue("mtype",mtype)
                .addValue("mid", mid)
                .addValue("currenttime", currentTime)
                .addValue("postLine", postLine)
                .addValue("needCheck", needCheck)
                .addValue("receiveCheck", receiveCheck)
                .addValue("fromParty", fromParty)
                .addValue("fromBank", fromBank)
                .addValue("fromAt", fromAt)
                .addValue("comments", comment);
        Map map = null;
        try {
            map = this.addproc.execute(params);
        } catch (Exception var5) {
            log.warn("Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

}
