package com.ptteng.wealth.finance.service;

import java.util.List;

import com.ptteng.wealth.finance.model.Order;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.osoa.sca.annotations.Remotable;
import com.ptteng.wealth.user.model.*;
import com.ptteng.wealth.finance.model.LoanApply;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface LoanApplyService extends BaseDaoService {


    public Long insert(LoanApply loanApply) throws ServiceException, ServiceDaoException;


    public List<LoanApply> insertList(List<LoanApply> loanApplyList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(LoanApply loanApply) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<LoanApply> loanApplyList) throws ServiceException, ServiceDaoException;


    public LoanApply getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<LoanApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLoanApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLoanApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getLoanApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLoanApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLoanApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLoanApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLoanApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLoanApplyIdsByUidAndOrderType(Long uid, Integer orderType, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLoanApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getLoanApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countLoanApplyIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Boolean addLoanApply(Order order, Long loanProductId, User user) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Boolean addSmallLoanApply(Order order, User user, Boolean ifVerify) throws ServiceException, ServiceDaoException;
}

