package com.ptteng.wealth.finance.model.account;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "accountRecord")
public class AccountRecord implements Serializable {

    public static final Integer MONEYTYPE_1 = 1;  //增加金额
    public static final Integer MONEYTYPE_2 = 2;  //减少金额
    public static final Integer MONEYTYPE_3 = 3;  //变化金额
    public static final  Integer TYPE_1=1;
    public static final  Integer TYPE_2=2;
    public static final  Integer TYPE_3=3;
    public static final  Integer TYPE_4=4;
    public static final  Integer need_check_y = 1;
    public static final  Integer need_check_n = 2;
    public static final  Integer receive_check_n = 1;
    public static final  Integer recevie_check_y = 2;
    /**
     * 1/待审核
     * 2/审核通过
     * 3/审核驳回
     */
    public static final Integer STATUS_1 = 1;
    public static final Integer STATUS_2= 2;
    public static final Integer STATUS_3 = 3;
    private static final long serialVersionUID = 8290886771679110144L;
    private Long id;
    private Long userId;
    private String mobile;
    private String orgCode;
    private String orgName;
    private Long accountId;
    private String accountCode;
    private Long toAccountId;
    private String toAccountCode;
    private Integer type;  //  1.线下转账  2.承兑汇票  3.电汇 4.调账
    private Long postLine;  //承兑汇票到期时间
    private Integer needCheck;  //是否需要汇款挂账确认函  1.需要  2.不需要
    private Integer receiveCheck;  //汇款挂账确认函是否到  1.未到  2.已到
    private String fromParty;  //来款方
    private String fromBank;   //来款银行
    private String fromAt;  //来款日期
    private String comment; //备注
    private String serialNum;
    private BigDecimal addMoney;
    private BigDecimal oldMoney;  //被转账账户之前的钱
    private BigDecimal lastMoney;
    private BigDecimal toOldMoney; //接受转账的账户，之前的钱
    private BigDecimal toLastMoney;  //接受转账的账户，转账后的钱
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    private Integer moneyType;
    private Integer status;  //1/待审核     2/审核通过       3/审核驳回
    private String refuseReason;

    public AccountRecord(){

    }


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "org_code")
    public String getOrgCode() {
        return orgCode;
    }


    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Column(name = "org_name")
    public String getOrgName() {
        return orgName;
    }


    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Column(name = "account_id")
    public Long getAccountId() {
        return accountId;
    }


    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "comments")
    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "from_at")
    public String getFromAt() {
        return fromAt;
    }

    public void setFromAt(String fromAt) {
        this.fromAt = fromAt;
    }

    @Column(name = "from_bank")
    public String getFromBank() {
        return fromBank;
    }

    public void setFromBank(String fromBank) {
        this.fromBank = fromBank;
    }

    @Column(name = "from_party")
    public String getFromParty() {
        return fromParty;
    }

    public void setFromParty(String fromParty) {
        this.fromParty = fromParty;
    }

    @Column(name = "receive_check")
    public Integer getReceiveCheck() {
        return receiveCheck;
    }

    public void setReceiveCheck(Integer receiveCheck) {
        this.receiveCheck = receiveCheck;
    }

    @Column(name = "need_check")
    public Integer getNeedCheck() {
        return needCheck;
    }

    public void setNeedCheck(Integer needCheck) {
        this.needCheck = needCheck;
    }

    @Column(name = "post_line")
    public Long getPostLine() {
        return postLine;
    }

    public void setPostLine(Long postLine) {
        this.postLine = postLine;
    }

    @Column(name = "serial_num")
    public String getSerialNum() {
        return serialNum;
    }


    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    @Column(name = "add_money")
    public BigDecimal getAddMoney() {
        return addMoney;
    }


    public void setAddMoney(BigDecimal addMoney) {
        this.addMoney = addMoney;
    }

    @Column(name = "last_money")
    public BigDecimal getLastMoney() {
        return lastMoney;
    }


    public void setLastMoney(BigDecimal lastMoney) {
        this.lastMoney = lastMoney;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "account_code")
    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }


    @Column(name = "money_type")
    public Integer getMoneyType() {
        return moneyType;
    }

    public void setMoneyType(Integer moneyType) {
        this.moneyType = moneyType;
    }


    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "to_account_code")
    public String getToAccountCode() {
        return toAccountCode;
    }

    public void setToAccountCode(String toAccountCode) {
        this.toAccountCode = toAccountCode;
    }

    @Column(name = "to_account_id")
    public Long getToAccountId() {
        return toAccountId;
    }

    public void setToAccountId(Long toAccountId) {
        this.toAccountId = toAccountId;
    }

    @Column(name = "old_money")
    public BigDecimal getOldMoney() {
        return oldMoney;
    }

    public void setOldMoney(BigDecimal oldMoney) {
        this.oldMoney = oldMoney;
    }

    @Column(name = "to_last_money")
    public BigDecimal getToLastMoney() {
        return toLastMoney;
    }

    public void setToLastMoney(BigDecimal toLastMoney) {
        this.toLastMoney = toLastMoney;
    }

    @Column(name = "to_old_money")
    public BigDecimal getToOldMoney() {
        return toOldMoney;
    }

    public void setToOldMoney(BigDecimal toOldMoney) {
        this.toOldMoney = toOldMoney;
    }


    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "refuse_reason")
    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

