package com.ptteng.wealth.finance.model;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by arthur on 16/8/26.
 */
@Entity
@Table(name = "loan_product")
public class LoanProduct implements Serializable {

    private static final long serialVersionUID = 336928618354233344L;

    public static final Integer DAL = 1;

    public static Integer SALE_ON_CREDIT = 1;         //采用赊销的理财产品 借款方开磷
    public static Integer SALE_ON_CREDIT_NOT = 2;     //采用借贷的理财产品 借款方金汇

    private Long id;
    private String name;
    private BigDecimal rate; //利率
    private BigDecimal overRate;//罚息利率
    private Integer repayLine;    //借款期限
    private BigDecimal ratio;    //缴纳保证金比例
    private Integer payManner;  //支付方式    1：赊销   2：借贷
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    private Integer dal;

    public LoanProduct() {
        this.createAt = System.currentTimeMillis();
        this.updateAt = System.currentTimeMillis();
    }


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    @Column(name = "rate")
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    @Column(name = "repay_line")
    public Integer getRepayLine() {
        return repayLine;
    }

    public void setRepayLine(Integer repayLine) {
        this.repayLine = repayLine;
    }

    @Column(name = "ratio")
    public BigDecimal getRatio() {
        return ratio;
    }

    public void setRatio(BigDecimal ratio) {
        this.ratio = ratio;
    }

    @Column(name = "over_rate")
    public BigDecimal getOverRate() {
        return overRate;
    }

    public void setOverRate(BigDecimal overRate) {
        this.overRate = overRate;
    }

    @Column(name = "pay_manner")
    public Integer getPayManner() {
        return payManner;
    }

    public void setPayManner(Integer payManner) {
        this.payManner = payManner;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {

        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "dal")
    public Integer getDal() {
        return dal;
    }

    public void setDal(Integer dal) {
        this.dal = dal;
    }


}
