package com.ptteng.wealth.finance.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "creditApply")
public class CreditApply implements Serializable {

    private static final long serialVersionUID = 4640501699995261952L;

    /**
     * 1/待审核
     * 2/审核通过
     * 3/审核驳回
     */
    public static final Integer STATUS_VERIFYING = 1;
    public static final Integer STATUS_PASS = 2;
    public static final Integer STATUS_REFUSE = 3;


    private Long id;
    private Long uid;
    private String orgName;
    private String reason;
    private String name;
    private String mobile;
    private BigDecimal lineBefore;
    private BigDecimal lineLeft;
    private BigDecimal lineApply;
    private BigDecimal lineFinal;
    private BigDecimal smallLineBefore;
    private BigDecimal smallLineLeft;
    private BigDecimal smallLineApply;
    private BigDecimal smallLineFinal;
    private Long verifyManager;
    private Integer status;
    private Long verifyAt;
    private String material;
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "reason")
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Column(name = "org_name")
    public String getOrgName() {
        return orgName;
    }


    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "line_before")
    public BigDecimal getLineBefore() {
        return lineBefore;
    }


    public void setLineBefore(BigDecimal lineBefore) {
        this.lineBefore = lineBefore;
    }

    @Column(name = "line_left")
    public BigDecimal getLineLeft() {
        return lineLeft;
    }


    public void setLineLeft(BigDecimal lineLeft) {
        this.lineLeft = lineLeft;
    }

    @Column(name = "line_apply")
    public BigDecimal getLineApply() {
        return lineApply;
    }


    public void setLineApply(BigDecimal lineApply) {
        this.lineApply = lineApply;
    }

    @Column(name = "line_final")
    public BigDecimal getLineFinal() {
        return lineFinal;
    }


    public void setLineFinal(BigDecimal lineFinal) {
        this.lineFinal = lineFinal;
    }

    @Column(name = "small_line_before")
    public BigDecimal getSmallLineBefore() {
        return smallLineBefore;
    }

    public void setSmallLineBefore(BigDecimal smallLineBefore) {
        this.smallLineBefore = smallLineBefore;
    }

    @Column(name = "small_line_left")
    public BigDecimal getSmallLineLeft() {
        return smallLineLeft;
    }

    public void setSmallLineLeft(BigDecimal smallLineLeft) {
        this.smallLineLeft = smallLineLeft;
    }

    @Column(name = "small_line_apply")
    public BigDecimal getSmallLineApply() {
        return smallLineApply;
    }

    public void setSmallLineApply(BigDecimal smallLineApply) {
        this.smallLineApply = smallLineApply;
    }

    @Column(name = "small_line_final")
    public BigDecimal getSmallLineFinal() {
        return smallLineFinal;
    }

    public void setSmallLineFinal(BigDecimal smallLineFinal) {
        this.smallLineFinal = smallLineFinal;
    }

    @Column(name = "verify_manager")
    public Long getVerifyManager() {
        return verifyManager;
    }


    public void setVerifyManager(Long verifyManager) {
        this.verifyManager = verifyManager;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "material")
    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    @Column(name = "verify_at")
    public Long getVerifyAt() {
        return verifyAt;
    }


    public void setVerifyAt(Long verifyAt) {
        this.verifyAt = verifyAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

