/**
 * 
 */
package com.ptteng.wealth.finance.client;

import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.RepayHistory;
import com.ptteng.wealth.finance.service.RepayHistoryService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class RepayHistorySCAClient implements RepayHistoryService {

    private RepayHistoryService repayHistoryService;

	public RepayHistoryService getRepayHistoryService() {
		return repayHistoryService;
	}
	
	
	public void setRepayHistoryService(RepayHistoryService repayHistoryService) {
		this.repayHistoryService =repayHistoryService;
	}
	
	
			   
		@Override
		public Long insert(RepayHistory repayHistory)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.insert(repayHistory);
		          
		
		}	
		  
    	   
		@Override
		public List<RepayHistory> insertList(List<RepayHistory> repayHistoryList)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.insertList(repayHistoryList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(RepayHistory repayHistory)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.update(repayHistory);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<RepayHistory> repayHistoryList)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.updateList(repayHistoryList);
		          
		
		}	
		  
    	   
		@Override
		public RepayHistory getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<RepayHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRepayHistoryIdsByName(String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.getRepayHistoryIdsByName(name,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRepayHistoryIdsByMobile(String mobile,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.getRepayHistoryIdsByMobile(mobile,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getRepayHistoryIdByOrderNo(String orderNo)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.getRepayHistoryIdByOrderNo(orderNo);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getRepayHistoryIdByNumber(String number)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.getRepayHistoryIdByNumber(number);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRepayHistoryIdsByName(String name)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.countRepayHistoryIdsByName(name);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRepayHistoryIdsByMobile(String mobile)throws ServiceException, ServiceDaoException{
		
		return repayHistoryService.countRepayHistoryIdsByMobile(mobile);
	
	
	}
	
		
	
		@Override
	public List<Long> getRepayHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return repayHistoryService.getRepayHistoryIds(start, limit);
	}

	@Override
	public Integer countRepayHistoryIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return repayHistoryService.countRepayHistoryIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return repayHistoryService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
		return this.repayHistoryService.getObjectByDynamicCondition(aClass, map, integer, integer1);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return repayHistoryService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   repayHistoryService.deleteList(clz, ids);
		
	}


 
}

