/**
 * 
 */
package com.ptteng.wealth.finance.client;

import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.Refunds;
import com.ptteng.wealth.finance.service.RefundsService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class RefundsSCAClient implements RefundsService {

    private RefundsService refundsService;

	public RefundsService getRefundsService() {
		return refundsService;
	}
	
	
	public void setRefundsService(RefundsService refundsService) {
		this.refundsService =refundsService;
	}
	
	
			   
		@Override
		public Long insert(Refunds refunds)throws ServiceException, ServiceDaoException{
		
		return refundsService.insert(refunds);
		          
		
		}	
		  
    	   
		@Override
		public List<Refunds> insertList(List<Refunds> refundsList)throws ServiceException, ServiceDaoException{
		
		return refundsService.insertList(refundsList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return refundsService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Refunds refunds)throws ServiceException, ServiceDaoException{
		
		return refundsService.update(refunds);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Refunds> refundsList)throws ServiceException, ServiceDaoException{
		
		return refundsService.updateList(refundsList);
		          
		
		}	
		  
    	   
		@Override
		public Refunds getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return refundsService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Refunds> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return refundsService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getRefundsIdByOrderNoAndRefundNo(String orderNo, String refundNo)throws ServiceException, ServiceDaoException{
		
		return refundsService.getRefundsIdByOrderNoAndRefundNo(orderNo, refundNo);
	
	
	}

	@Override
	public Long getRefundsIdByRefundNo(String refundNo) throws ServiceException, ServiceDaoException {
		return refundsService.getRefundsIdByRefundNo(refundNo);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRefundsIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return refundsService.getRefundsIdsByUidAndStatus(uid,status,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRefundsIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return refundsService.getRefundsIdsByUid(uid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRefundsIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		return refundsService.countRefundsIdsByUidAndStatus(uid,status);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRefundsIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return refundsService.countRefundsIdsByUid(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getRefundsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return refundsService.getRefundsIds(start, limit);
	}

	@Override
	public Integer countRefundsIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return refundsService.countRefundsIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return refundsService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
		return this.refundsService.getObjectByDynamicCondition(aClass, map, integer, integer1);

	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return refundsService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   refundsService.deleteList(clz, ids);
		
	}
 
}

