/**
 * 
 */
package com.ptteng.wealth.finance.client;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.Invest;
import com.ptteng.wealth.finance.service.InvestService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class InvestSCAClient implements InvestService {

    private InvestService investService;

	public InvestService getInvestService() {
		return investService;
	}
	
	
	public void setInvestService(InvestService investService) {
		this.investService =investService;
	}
	
	
			   
		@Override
		public Long insert(Invest invest)throws ServiceException, ServiceDaoException{
		
		return investService.insert(invest);
		          
		
		}	
		  
    	   
		@Override
		public List<Invest> insertList(List<Invest> investList)throws ServiceException, ServiceDaoException{
		
		return investService.insertList(investList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return investService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Invest invest)throws ServiceException, ServiceDaoException{
		
		return investService.update(invest);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Invest> investList)throws ServiceException, ServiceDaoException{
		
		return investService.updateList(investList);
		          
		
		}	
		  
    	   
		@Override
		public Invest getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return investService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Invest> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return investService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getInvestIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return investService.getInvestIdsByUidAndStatus(uid,status,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getInvestIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return investService.getInvestIdsByUid(uid,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getInvestIdsByUidAndPid(Long uid,Long pid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return investService.getInvestIdsByUidAndPid(uid,pid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countInvestIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		return investService.countInvestIdsByUidAndStatus(uid,status);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countInvestIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return investService.countInvestIdsByUid(uid);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countInvestIdsByUidAndPid(Long uid,Long pid)throws ServiceException, ServiceDaoException{
		
		return investService.countInvestIdsByUidAndPid(uid,pid);
	
	
	}
	
		
	
		@Override
	public List<Long> getInvestIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return investService.getInvestIds(start, limit);
	}

	@Override
	public Integer countInvestIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return investService.countInvestIds();
	}

	@Override
	public Long addInvest(Long uid, Long pid, Integer paymentType, BigDecimal amount, String bankName, String name, String mobile, String cardNo, Long inteAt) throws ServiceException, ServiceDaoException {
		return investService.addInvest(uid, pid, paymentType, amount, bankName, name, mobile, cardNo, inteAt);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return investService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
		return this.investService.getObjectByDynamicCondition(aClass, map, integer, integer1);

	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return investService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   investService.deleteList(clz, ids);
		
	}


 
}

