package com.ptteng.wealth.finance.service.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import org.osoa.sca.annotations.Remotable;

import java.util.List;
import java.util.Map;

@Remotable
public interface UserAccountRelationService extends BaseDaoService {


    public Long insert(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException;


    public List<UserAccountRelation> insertList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException;


    public UserAccountRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserAccountRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserAccountRelationIdsByUserId(Long userId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserAccountRelationIdByUserIdAndAccountId(Long userId, Long accountId) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserAccountRelationIdByUserIdAndAccountCode(Long userId, String accountCode) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserAccountRelationIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserAccountRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserAccountRelationIds() throws ServiceException, ServiceDaoException;


    /**
     * 生成调账的记录
     */
    public int swapMoney(Long fromId, Long toId, Double money, String serialNo, Long mid, String comments) throws ServiceException, ServiceDaoException;

    /**
     * 实际执行调账操作
     */
    public int execMoney(Long recordId, Long userId) throws ServiceException, ServiceDaoException;

    //创建上账操作记录
    public int addResult(Long acountid, Double amount, String serialNo, Integer mtype, Long mid, Long postLine, Integer needCheck,
                         Integer receiveCheck, String fromParty, String fromBank, String fromAt, String comment)
            throws ServiceException, ServiceDaoException;

    //实际执行上账操作
    public int addExec(Long recordId, Long mid) throws ServiceException, ServiceDaoException;

    //订单支付---开磷账户支付
    public int payOrder(Long orderId, Long userAccountId, Integer payType) throws ServiceException, ServiceDaoException;

    //信用支付 --- 开磷账户 缴纳保证金
    public int payDeposit(Long userAccountId, Double paymoney, Double debtCount, Long debtApplyId, Long uid, Long orderId, Long overAt);

    //信用支付  -- 开磷账户 缴纳保证金成功设置状态
    public int payDepositdaixiao(Double debtCount, Long debtApplyId, Long uid, Long orderId, Long overAt);

    public int shexiaoKL(Long userAccountId, Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime);

    public int shexiaoDX(Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime);

}

