package com.ptteng.wealth.finance.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Invest;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InvestService extends BaseDaoService {

	



   		   
		
		public Long insert(Invest invest)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Invest> insertList(List<Invest> investList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Invest invest)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Invest> investList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Invest getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Invest> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countInvestIdsByUidAndStatus(Long uid, Integer status)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countInvestIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countInvestIdsByUidAndPid(Long uid, Long pid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getInvestIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getInvestIdsByUid(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getInvestIdsByUidAndPid(Long uid, Long pid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getInvestIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countInvestIds() throws ServiceException, ServiceDaoException;


	public Long addInvest(Long uid, Long pid, Integer paymentType, BigDecimal amount, String bankName, String name, String mobile,
						  String cardNo, Long inteAt) throws ServiceException , ServiceDaoException ;
}

