package com.ptteng.wealth.finance.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.FundHistory;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface FundHistoryService extends BaseDaoService {

	



   		   
		
		public Long insert(FundHistory fundHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<FundHistory> insertList(List<FundHistory> fundHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(FundHistory fundHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<FundHistory> fundHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public FundHistory getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<FundHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countFundHistoryIdsByUidAndStatusAndType(Long uid, Integer status, Integer type)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countFundHistoryIdsByUidAndType(Long uid, Integer type)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getFundHistoryIdsByUidAndStatusAndType(Long uid, Integer status, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getFundHistoryIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getFundHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countFundHistoryIds() throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long insertTransaction(Order order, User user, Integer type, Integer detail, Long payAccount,
								  BigDecimal amount, String comment, Integer flag, Integer status, String serialNum,
								  BigDecimal before, BigDecimal after) throws ServiceException, ServiceDaoException;
}

