package com.ptteng.wealth.finance.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.DebtApply;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface DebtApplyService extends BaseDaoService {


    public Long insert(DebtApply debtApply) throws ServiceException, ServiceDaoException;


    public List<DebtApply> insertList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(DebtApply debtApply) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException;


    public DebtApply getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<DebtApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDebtApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDebtApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getDebtApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDebtApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDebtApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDebtApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDebtApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDebtApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<DebtApply> getObjectsBySql(Class clz, String sql) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDebtApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDebtApplyIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Boolean addDebtApply(Order order, Long loanProductId , User user) throws ServiceException, ServiceDaoException;
}

