package com.ptteng.wealth.finance.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "orders")
public class Order implements Serializable {

    //贵州开磷息峰合成氨有限责任公司
    public static final Integer DEPARTMENT_A = 1;
    //贵州开磷化肥有限责任公司
    public static final Integer DEPARTMENT_B = 2;
    //贵州开磷有限责任公司
    public static final Integer DEPARTMENT_C = 3;
    //贵州开磷集团国际贸易有限公司
    public static final Integer DEPARTMENT_D = 4;
    /**
     * 失败
     */
    public static final Integer STATUS_FAIL = 1;
    /**
     * 完成
     */
    public static final Integer STATUS_COMPLETE = 0;
    /**
     * 执行中
     */
    public static final Integer STATUS_PROCCESS = 2;
    /**
     * 已通知 对方已收到通知结果
     */
    public static final Integer Notify_Satus_Notify = 0;
    /**
     * 未通知  新建的订单，一次未通知的，是未通知
     */
    public static final Integer Notify_Satus_Unnotify = 1;
    /**
     * 已过期  连续发送，超过24小时，是已过期
     */
    public static final Integer Notify_Satus_Expire = 2;
    /**
     * 证联余额支付
     */
    public static final Integer Pay_Type_fund = 1;
    /**
     * 信用支付
     */
    public static final Integer Pay_Type_credit = 2;
    /**
     * 承兑汇票
     */
    public static final Integer Pay_Type_post = 3;
    /**
     * 电汇
     */
    public static final Integer Pay_Type_check = 4;
    /**
     * 开磷余额支付
     */
    public static final Integer Pay_Type_klfund = 5;
    /**
     *  赊销支付
     */
    public static final Integer Pay_Type_Loan = 6;
    /**
     * 借贷支付
     */
    public static final Integer Pay_Type_Debt = 7;
    /**
     * 小额支付
     */
    public static final Integer Pay_Type_Small = 8;
    /**
     * 来源：B2B
     */
    public static final Integer Pay_Resource_b2b = 1;
    /**
     * 来源：OMS
     */
    public static final Integer Pay_Resource_oms = 2;
    /**
     * 线上支付
     */
    public static final Integer Pay_online = 1;
    /**
     * 线下支付
     */
    public static final Integer Pay_offline = 2;
    /**
     * 订单类型 ：1 正常订单
     */
    public static final Integer Type_normal = 1;
    /**
     * 订单类型 ：2 小额订单
     */
    public static final Integer Type_small = 2;
    /**
     * 信用产品选择状态 ：1 未选择
     */
    public static final Integer product_status_not_choice = 1;
    /**
     * 信用产品选择状态 ：2 已选择
     */
    public static final Integer product_status_choice = 2;
    /**
     *
     */
    private static final long serialVersionUID = 336928618354233344L;
    private Long id;
    private Long uid;
    private String company;       //订单中商品的生产厂家，暂时没有用到
    private Integer department;   //订单中产品的生产部门
    private String orderNo;       //订单编号
    private BigDecimal priceTot;  //订单总价
    private Integer status;       //订单执行的状态  目前是3种   失败|完成|执行中
    private String info;          //订单中商品的具体信息
    private Long orderAt;
    private Long payAt;       //订单支付成功的时间
    private Integer payType; //支付方式     1 余额支付   2 信用支付 3 承兑汇票  4 电汇  5 开磷余额支付   6  赊销支付   7  借贷支付   8  小额支付
    private Integer resource; // 订单来源  1 B2B  2 OMS
    private Long nextnNotifyAt = 1L;
    private Integer notifyCount = 0;
    private Integer notifyStatus = 1;
    private String returnUrl;
    private String notifyUrl;  // 回调 B2B|OMS 的地址
    private Integer orderType; //订单类型 1 正常订单 2 小额订单
    private Integer productStatus = product_status_not_choice;//信用支付产品选择状态 1 未选 2 已选

    private Integer payLine;  //支付渠道   1 线上  2 线下
    private Long confirmAt;
    private String additional; //补款订单号，非补款订单为订单号
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "department")
    public Integer getDepartment() {
        return department;
    }

    public void setDepartment(Integer department) {
        this.department = department;
    }

    @Column(name = "pay_type")
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    @Column(name = "resource")
    public Integer getResource() {
        return resource;
    }

    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Column(name = "order_no")
    public String getOrderNo() {
        return orderNo;
    }


    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @Column(name = "price_tot")
    public BigDecimal getPriceTot() {
        return priceTot;
    }


    public void setPriceTot(BigDecimal priceTot) {
        this.priceTot = priceTot;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "info")
    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    @Column(name = "pay_line")
    public Integer getPayLine() {
        return payLine;
    }

    public void setPayLine(Integer payLine) {
        this.payLine = payLine;
    }

    @Column(name = "order_at")
    public Long getOrderAt() {
        return orderAt;
    }

    public void setOrderAt(Long orderAt) {
        this.orderAt = orderAt;
    }

    @Column(name = "pay_at")
    public Long getPayAt() {
        return payAt;
    }

    public void setPayAt(Long payAt) {
        this.payAt = payAt;
    }

    @Column(name = "notify_count")
    public Integer getNotifyCount() {
        return notifyCount;
    }

    public void setNotifyCount(Integer notifyCount) {
        this.notifyCount = notifyCount;
    }

    @Column(name = "notify_status")
    public Integer getNotifyStatus() {
        return notifyStatus;
    }

    public void setNotifyStatus(Integer notifyStatus) {
        this.notifyStatus = notifyStatus;
    }

    @Column(name = "notify_url")
    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    @Column(name = "order_type")
    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    @Column(name = "product_status")
    public Integer getProductStatus() {
        return productStatus;
    }

    public void setProductStatus(Integer productStatus) {
        this.productStatus = productStatus;
    }

    @Column(name = "confirm_at")
    public Long getConfirmAt() {
        return confirmAt;
    }

    public void setConfirmAt(Long confirmAt) {
        this.confirmAt = confirmAt;
    }

    @Column(name = "next_notify_at")
    public Long getNextnNotifyAt() {
        return nextnNotifyAt;
    }

    public void setNextnNotifyAt(Long nextnNotifyAt) {
        this.nextnNotifyAt = nextnNotifyAt;
    }

    @Column(name = "additional")
    public String getAdditional() {
        return additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "return_url")
    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Column(name = "company")
    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

