package com.ptteng.wealth.finance.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * 借款申请
 */
@Entity
@Table(name = "loan_apply")
public class LoanApply implements Serializable {

    //审核中
    public static final Integer STATUS_VERIFYING = 1;
    //开磷认证通过
    public static final Integer STATUS_KAILIN_PASS = 2;
    //金汇认证通过
    public static final Integer STATUS_PASS = 3;
    //还款中
    public static final Integer STATUS_REPAY = 4;
    //逾期
    public static final Integer STATUS_OVERTIME = 5;
    //已还清
    public static final Integer STATUS_CLEAR = 6;
    //金汇审核拒绝
    public static final Integer STATUS_REFUSE = 7;
    //开磷审核拒绝
    public static final Integer STATUS_KAILIN_REFUSE = 8;
    //取消借款
    public static final Integer STATUS_CANCEL = 9;
    //审核中
    public static final Integer TYPE_VERIFYING = 1;
    //还款中
    public static final Integer TYPE_REPAY = 2;
    //逾期
    public static final Integer TYPE_OVERTIME = 3;
    //已还清
    public static final Integer TYPE_CLEAR = 4;
    //已取消
    public static final Integer TYPE_CANCEL = 5;
    public static final Integer REPAYWAY_1 = 1;
    private static final long serialVersionUID = 7999686702474580992L;
    public static Integer ORDER_TYPE_LOAN = 1;     //采用赊销的理财产品 借款方开磷
    public static Integer ORDER_TYPE_DEBT = 2;     //采用借贷的理财产品 借款方金汇
    public static Integer ORDER_TYPE_SMALL = 3;    //采用借贷的理财产品 借款方开磷 小额贷款
    private Long id;
    private Long uid;
    private String userMobile;
    private String userName;
    /**
     * 订单ID
     */
    private Long orderID;
    private String orderNo;
    private Integer status;
    private Integer type;
    private BigDecimal total;//订单总价
    private BigDecimal debtCount;//借款总数
    private BigDecimal rate;//利率
    private BigDecimal overRate;//罚息利率

    private Integer repayWay; //还款方式，目前只有一种，一次性还本付息
    private String reason;

    private Integer repayLine;    //借款期限
    private BigDecimal repayTot;    //还款金额

    private Long overAt;    //预计还款日期
    private Long verifyAt = 0L;
    private Long secondVerifyAt = 0L;
    private Long debtAt;//终审通过时间，也是还款计息时间
    private BigDecimal clearInte;//还款利息
    private BigDecimal clearOverInte; //还款罚息

    private BigDecimal overDayCount;    //清偿逾期时间
    private Long clearAt;    //还款时间
    private Long verifyBy = 0L; //FSP 后台初审时间
    private Long secondVerifyBy = 0L; //FSP后台终审时间
    private Integer orderType; //订单类型： 1、赊销 2、借贷 3、小额
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    private String additional;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "user_mobile")
    public String getUserMobile() {
        return userMobile;
    }

    public void setUserMobile(String userMobile) {
        this.userMobile = userMobile;
    }

    @Column(name = "user_name")
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name = "order_id")
    public Long getOrderID() {
        return orderID;
    }


    public void setOrderID(Long orderID) {
        this.orderID = orderID;
    }


    @Column(name = "order_no")
    public String getOrderNo() {
        return orderNo;
    }


    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @Column(name = "total")
    public BigDecimal getTotal() {
        return total;
    }


    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    @Column(name = "debt_count")
    public BigDecimal getDebtCount() {
        return debtCount;
    }


    public void setDebtCount(BigDecimal debtCount) {
        this.debtCount = debtCount;
    }

    @Column(name = "rate")
    public BigDecimal getRate() {
        return rate;
    }


    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    @Column(name = "over_rate")
    public BigDecimal getOverRate() {
        return overRate;
    }


    public void setOverRate(BigDecimal overRate) {
        this.overRate = overRate;
    }

    @Column(name = "repay_way")
    public Integer getRepayWay() {
        return repayWay;
    }


    public void setRepayWay(Integer repayWay) {
        this.repayWay = repayWay;
    }

    @Column(name = "reason")
    public String getReason() {
        return reason;
    }


    public void setReason(String reason) {
        this.reason = reason;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }


    @Column(name = "repay_line")
    public Integer getRepayLine() {
        return repayLine;
    }

    public void setRepayLine(Integer repayLine) {
        this.repayLine = repayLine;
    }

    @Column(name = "repay_tot")
    public BigDecimal getRepayTot() {
        return repayTot;
    }


    public void setRepayTot(BigDecimal repayTot) {
        this.repayTot = repayTot;
    }

    @Column(name = "over_at")
    public Long getOverAt() {
        return overAt;
    }


    public void setOverAt(Long overAt) {
        this.overAt = overAt;
    }

    @Column(name = "verify_at")
    public Long getVerifyAt() {
        return verifyAt;
    }


    public void setVerifyAt(Long verifyAt) {
        this.verifyAt = verifyAt;
    }


    @Column(name = "second_verify_at")
    public Long getSecondVerifyAt() {
        return secondVerifyAt;
    }


    public void setSecondVerifyAt(Long secondVerifyAt) {
        this.secondVerifyAt = secondVerifyAt;
    }


    @Column(name = "verify_by")
    public Long getVerifyBy() {
        return verifyBy;
    }


    public void setVerifyBy(Long verifyBy) {
        this.verifyBy = verifyBy;
    }

    @Column(name = "second_verify_by")
    public Long getSecondVerifyBy() {
        return secondVerifyBy;
    }


    public void setSecondVerifyBy(Long secondVerifyBy) {
        this.secondVerifyBy = secondVerifyBy;
    }


    @Column(name = "clear_inte")
    public BigDecimal getClearInte() {
        return clearInte;
    }


    public void setClearInte(BigDecimal clearInte) {
        this.clearInte = clearInte;
    }

    @Column(name = "clear_over_inte")
    public BigDecimal getClearOverInte() {
        return clearOverInte;
    }


    public void setClearOverInte(BigDecimal clearOverInte) {
        this.clearOverInte = clearOverInte;
    }

    @Column(name = "over_day_count")
    public BigDecimal getOverDayCount() {
        return overDayCount;
    }

    public void setOverDayCount(BigDecimal overDayCount) {
        this.overDayCount = overDayCount;
    }


    @Column(name = "debt_at")
    public Long getDebtAt() {
        return debtAt;
    }


    public void setDebtAt(Long debtAt) {
        this.debtAt = debtAt;
    }


    @Column(name = "clear_at")
    public Long getClearAt() {
        return clearAt;
    }


    public void setClearAt(Long clearAt) {
        this.clearAt = clearAt;
    }

    @Column(name = "order_type")
    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "additional")
    public String getAdditional() {
        return additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

