package com.ptteng.wealth.finance.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "invest")
public class Invest implements Serializable {

    /**
     * 证联余额支付
     */
    public static final Integer Pay_Type_fund = 1;
    /**
     * 银行卡支付
     */
    public static final Integer Pay_Type_card = 2;
    /**
     * 执行中
     */
    public static final Integer STATUS_PROCCESS = 1;
    /**
     * 完成
     */
    public static final Integer STATUS_COMPLETE = 2;
    /**
     *
     */
    private static final long serialVersionUID = 866604567284843520L;
    private Long id;


    private Long uid;


    private String name;


    private String mobile;


    private Long pid;


    private BigDecimal amount;


    private Integer paymentType;


    private Integer status;


    private Long cid;


    private String cardNo;


    private String bankName;


    private Long inteAt;


    private Long rewardAt;


    private String comment;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "pid")
    public Long getPid() {
        return pid;
    }


    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Column(name = "amount")
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }


    @Column(name = "payment_type")
    public Integer getPaymentType() {
        return paymentType;
    }


    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "cid")
    public Long getCid() {
        return cid;
    }


    public void setCid(Long cid) {
        this.cid = cid;
    }

    @Column(name = "card_no")
    public String getCardNo() {
        return cardNo;
    }


    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }


    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Column(name = "inte_at")
    public Long getInteAt() {
        return inteAt;
    }


    public void setInteAt(Long inteAt) {
        this.inteAt = inteAt;
    }

    @Column(name = "reward_at")
    public Long getRewardAt() {
        return rewardAt;
    }


    public void setRewardAt(Long rewardAt) {
        this.rewardAt = rewardAt;
    }

    @Column(name = "comment")
    public String getComment() {
        return comment;
    }


    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

