package com.ptteng.wealth.finance.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "fundHistory")
public class FundHistory implements Serializable {

    //上账充值
    public static final Integer DETAIL_Charge = 1;
    //上账提现
    public static final Integer DETAIL_Draw = 2;
    //支付订单
    public static final Integer DETAIL_Pay = 3;
    //缴纳保证金
    public static final Integer DETAIL_Deposit = 4;
    //还款
    public static final Integer DETAIL_Repay = 5;
    //订单退款
    public static final Integer DETAIL_Refund = 6;
    //上账 转账充值
    public static final Integer TYPE_Charge_Account = 1;
    //转账至其他账户
    public static final Integer TYPE_Draw_Account = 2;
    //支付记录
    public static final Integer TYPE_Pay = 3;
    //退款记录
    public static final Integer TYPE_Refund = 4;
    //支出
    public static final Integer FLAG_Out = 1;
    //收入
    public static final Integer FLAG_In = 2;
    //审核中
    public static final Integer STATUS_Verify = 1;
    //审核通过
    public static final Integer STATUS_Pass = 2;
    //拒绝
    public static final Integer STATUS_Refuse = 3;
    /**
     *
     */
    private static final long serialVersionUID = 957701996028124160L;
    private Long id;

    //客户id
    private Long uid;

    //客户姓名
    private String name;

    //客户手机号
    private String mobile;

    //流水类型  1-上账 2-支付记录 3-退款记录
    private Integer type;

    //客户类型
    private Integer userType;

    //类型明细  1-上账充值 2-上账提现 3-支付订单 4-缴纳保证金 5-还款 6-订单退款
    private Integer detail;

    //支付账户id
    private Long payAccountId;

    //支付账户
    private String payAccountName;

    //发生金额
    private BigDecimal amount;

    //备注
    private String comment;

    //订单号
    private String orderNo;

    //补款/退款单号
    private String additional;

    //增减标志 1-支出 2-收入
    private Integer flag;

    //状态  （只有退款有） 1-审核中 2-审核通过 3-拒绝
    private Integer status;

    //交易编号
    private String serialNum;

    //交易前金额
    private BigDecimal beforeTransaction;

    //交易后余额
    private BigDecimal afterTransaction;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "user_type")
    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Column(name = "detail")
    public Integer getDetail() {
        return detail;
    }

    public void setDetail(Integer detail) {
        this.detail = detail;
    }

    @Column(name = "pay_account_id")
    public Long getPayAccountId() {
        return payAccountId;
    }

    public void setPayAccountId(Long payAccountId) {
        this.payAccountId = payAccountId;
    }

    @Column(name = "pay_account_name")
    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    @Column(name = "amount")
    public BigDecimal getAmount() {
        return amount;
    }


    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Column(name = "comment")
    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "additional")
    public String getAdditional() {
        return additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }

    @Column(name = "flag")
    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    @Column(name = "serial_num")
    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    @Column(name = "order_no")
    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "before_transaction")
    public BigDecimal getBeforeTransaction() {
        return beforeTransaction;
    }

    public void setBeforeTransaction(BigDecimal beforeTransaction) {
        this.beforeTransaction = beforeTransaction;
    }

    @Column(name = "after_transaction")
    public BigDecimal getAfterTransaction() {
        return afterTransaction;
    }

    public void setAfterTransaction(BigDecimal afterTransaction) {
        this.afterTransaction = afterTransaction;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

