package com.ptteng.wealth.finance.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "fund")
public class Fund implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 7748716853879537664L;


    private Long id;


    private BigDecimal fund= new BigDecimal("0");


    private BigDecimal fundA;


    private BigDecimal fundB;


    private BigDecimal fundC;


    private BigDecimal frozen = new BigDecimal("0");


    private BigDecimal creditLine = new BigDecimal("0");


    private BigDecimal smallLoanLine = new BigDecimal("0");


    private BigDecimal smallLoanTot = new BigDecimal("0");


    private BigDecimal todaySmallLoan = new BigDecimal("0");


    private Long lastSmallLoan = 0L;


    private Integer fastCount = 0;


    private BigDecimal loanTot = new BigDecimal("0");


    private BigDecimal loanNowTot = new BigDecimal("0");


    private BigDecimal overdueTot = new BigDecimal("0");


    private BigDecimal repayTot = new BigDecimal("0");


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "fund")
    public BigDecimal getFund() {
        return fund;
    }

    public void setFund(BigDecimal fund) {
        this.fund = fund;
    }

    @Column(name = "fund_a")
    public BigDecimal getFundA() {
        return fundA;
    }

    public void setFundA(BigDecimal fundA) {
        this.fundA = fundA;
    }

    @Column(name = "fund_b")
    public BigDecimal getFundB() {
        return fundB;
    }

    public void setFundB(BigDecimal fundB) {
        this.fundB = fundB;
    }

    @Column(name = "fund_c")
    public BigDecimal getFundC() {
        return fundC;
    }

    public void setFundC(BigDecimal fundC) {
        this.fundC = fundC;
    }


    @Column(name = "frozen")
    public BigDecimal getFrozen() {
        return frozen;
    }


    public void setFrozen(BigDecimal frozen) {
        this.frozen = frozen;
    }

    @Column(name = "credit_line")
    public BigDecimal getCreditLine() {
        return creditLine;
    }


    public void setCreditLine(BigDecimal creditLine) {
        this.creditLine = creditLine;
    }

    @Column(name = "small_loan_line")
    public BigDecimal getSmallLoanLine() {
        return smallLoanLine;
    }

    public void setSmallLoanLine(BigDecimal smallLoanLine) {
        this.smallLoanLine = smallLoanLine;
    }

    @Column(name = "small_loan_tot")
    public BigDecimal getSmallLoanTot() {
        return smallLoanTot;
    }

    public void setSmallLoanTot(BigDecimal smallLoanTot) {
        this.smallLoanTot = smallLoanTot;
    }

    @Column(name = "today_small_loan")
    public BigDecimal getTodaySmallLoan() {
        return todaySmallLoan;
    }

    public void setTodaySmallLoan(BigDecimal todaySmallLoan) {
        this.todaySmallLoan = todaySmallLoan;
    }

    @Column(name = "last_small_loan")
    public Long getLastSmallLoan() {
        return lastSmallLoan;
    }

    public void setLastSmallLoan(Long lastSmallLoan) {
        this.lastSmallLoan = lastSmallLoan;
    }

    @Column(name = "fast_count")
    public Integer getFastCount() {
        return fastCount;
    }


    public void setFastCount(Integer fastCount) {
        this.fastCount = fastCount;
    }

    @Column(name = "loan_tot")
    public BigDecimal getLoanTot() {
        return loanTot;
    }


    public void setLoanTot(BigDecimal loanTot) {
        this.loanTot = loanTot;
    }

    @Column(name = "loan_now_tot")
    public BigDecimal getLoanNowTot() {
        return loanNowTot;
    }


    public void setLoanNowTot(BigDecimal loanNowTot) {
        this.loanNowTot = loanNowTot;
    }

    @Column(name = "overdue_tot")
    public BigDecimal getOverdueTot() {
        return overdueTot;
    }


    public void setOverdueTot(BigDecimal overdueTot) {
        this.overdueTot = overdueTot;
    }

    @Column(name = "repay_tot")
    public BigDecimal getRepayTot() {
        return repayTot;
    }


    public void setRepayTot(BigDecimal repayTot) {
        this.repayTot = repayTot;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

