package com.ptteng.wealth.finance.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.service.LoanProductService;
import org.osoa.sca.annotations.Reference;

import java.util.List;
import java.util.Map;

/**
 * Created by arthur on 16/8/26.
 */
public class LoanProductSCAClient implements LoanProductService {

    @Reference
    private LoanProductService loanProductService;

    public LoanProductService getLoanProductService() {
        return loanProductService;
    }

    public void setLoanProductService(LoanProductService loanProductService) {
        this.loanProductService = loanProductService;
    }

    @Override
    public Long insert(LoanProduct loanProduct) throws ServiceException, ServiceDaoException {
        return  loanProductService.insert(loanProduct);
    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        return  loanProductService.delete(id);
    }

    @Override
    public boolean update(LoanProduct loanProduct) throws ServiceException, ServiceDaoException {
       return  loanProductService.update(loanProduct);
    }

    @Override
    public LoanProduct getObjectById(Long id) throws ServiceException, ServiceDaoException {
       return  loanProductService.getObjectById(id);
    }

    @Override
    public List<LoanProduct> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
       return  loanProductService.getObjectsByIds(ids);
    }

    @Override
    public List<Long> getLoanIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return  loanProductService.getLoanIds(start, limit);
    }

    @Override
    public List<LoanProduct> getLoanProductByManner(Integer payManner) throws ServiceException, ServiceDaoException {
        return  loanProductService.getLoanProductByManner(payManner);
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
       return  loanProductService.getIdsByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return this.loanProductService.getObjectByDynamicCondition(aClass, map, integer, integer1);

    }

    @Override
    public boolean fakeDelete(Class aClass, Long aLong) throws ServiceException, ServiceDaoException {
        return  loanProductService.fakeDelete(aClass, aLong);
    }

    @Override
    public void deleteList(Class aClass, List<Long> list) throws ServiceException, ServiceDaoException {
         loanProductService.deleteList(aClass, list);
    }
}
