/**
 *
 */
package com.ptteng.wealth.finance.client;

import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.Invoice;
import com.ptteng.wealth.finance.service.InvoiceService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class InvoiceSCAClient implements InvoiceService {

    private InvoiceService invoiceService;

    public InvoiceService getInvoiceService() {
        return invoiceService;
    }


    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }


    @Override
    public Long insert(Invoice invoice) throws ServiceException, ServiceDaoException {

        return invoiceService.insert(invoice);


    }


    @Override
    public List<Invoice> insertList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {

        return invoiceService.insertList(invoiceList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return invoiceService.delete(id);


    }


    @Override
    public boolean update(Invoice invoice) throws ServiceException, ServiceDaoException {

        return invoiceService.update(invoice);


    }


    @Override
    public boolean updateList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {

        return invoiceService.updateList(invoiceList);


    }


    @Override
    public Invoice getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return invoiceService.getObjectById(id);


    }


    @Override
    public List<Invoice> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return invoiceService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return invoiceService.getInvoiceIdsByUidAndType(uid, type, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return invoiceService.getInvoiceIdsByUid(uid, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {

        return invoiceService.countInvoiceIdsByUidAndType(uid, type);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        return invoiceService.countInvoiceIdsByUid(uid);


    }


    @Override
    public List<Long> getInvoiceIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.getInvoiceIds(start, limit);
    }

    @Override
    public Integer countInvoiceIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.countInvoiceIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return this.invoiceService.getObjectByDynamicCondition(aClass, map, integer, integer1);

    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        invoiceService.deleteList(clz, ids);

    }


}

