/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.test;

import java.io.File;
import java.net.InetSocketAddress;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.ServerInfo;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdfs.test.DownloadFileWriter;
import org.csource.fastdfs.test.UploadLocalFileSender;

public class TestClient1 {
    private TestClient1() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Error: Must have 2 parameters, one is config filename, the other is the local filename to upload");
            return;
        }
        System.out.println("java.version=" + System.getProperty("java.version"));
        String conf_filename = args[0];
        String local_filename = args[1];
        try {
            String generated_slave_file_id;
            ClientGlobal.init(conf_filename);
            System.out.println("network_timeout=" + ClientGlobal.g_network_timeout + "ms");
            System.out.println("charset=" + ClientGlobal.g_charset);
            TrackerClient tracker = new TrackerClient();
            TrackerServer trackerServer = tracker.getConnection();
            StorageServer storageServer = null;
            StorageClient1 client = new StorageClient1(trackerServer, storageServer);
            String group_name = "group1";
            StorageServer[] storageServers = tracker.getStoreStorages(trackerServer, group_name);
            if (storageServers == null) {
                System.err.println("get store storage servers fail, error code: " + tracker.getErrorCode());
            } else {
                System.err.println("store storage servers count: " + storageServers.length);
                for (int k = 0; k < storageServers.length; ++k) {
                    System.err.println(k + 1 + ". " + storageServers[k].getInetSocketAddress().getAddress().getHostAddress() + ":" + storageServers[k].getInetSocketAddress().getPort());
                }
                System.err.println("");
            }
            NameValuePair[] meta_list = new NameValuePair[]{new NameValuePair("width", "800"), new NameValuePair("heigth", "600"), new NameValuePair("bgcolor", "#FFFFFF"), new NameValuePair("author", "Mike")};
            byte[] file_buff = "this is a test".getBytes(ClientGlobal.g_charset);
            System.out.println("file length: " + file_buff.length);
            String file_id = client.upload_file1(file_buff, "txt", meta_list);
            if (file_id == null) {
                System.err.println("upload file fail, error code: " + client.getErrorCode());
                return;
            }
            System.err.println("file_id: " + file_id);
            System.err.println(client.get_file_info1(file_id));
            ServerInfo[] servers = tracker.getFetchStorages1(trackerServer, file_id);
            if (servers == null) {
                System.err.println("get storage servers fail, error code: " + tracker.getErrorCode());
            } else {
                System.err.println("storage servers count: " + servers.length);
                for (int k = 0; k < servers.length; ++k) {
                    System.err.println(k + 1 + ". " + servers[k].getIpAddr() + ":" + servers[k].getPort());
                }
                System.err.println("");
            }
            meta_list = new NameValuePair[]{new NameValuePair("width", "1024"), new NameValuePair("heigth", "768"), new NameValuePair("bgcolor", "#000000"), new NameValuePair("title", "Untitle")};
            int errno = client.set_metadata1(file_id, meta_list, (byte)77);
            if (errno == 0) {
                System.err.println("set_metadata success");
            } else {
                System.err.println("set_metadata fail, error no: " + errno);
            }
            meta_list = client.get_metadata1(file_id);
            if (meta_list != null) {
                for (int i = 0; i < meta_list.length; ++i) {
                    System.out.println(meta_list[i].getName() + " " + meta_list[i].getValue());
                }
            }
            if ((file_buff = client.download_file1(file_id)) != null) {
                System.out.println("file length:" + file_buff.length);
                System.out.println(new String(file_buff));
            }
            String master_file_id = file_id;
            String prefix_name = "-part1";
            String file_ext_name = "txt";
            file_buff = "this is a slave buff.".getBytes(ClientGlobal.g_charset);
            String slave_file_id = client.upload_file1(master_file_id, prefix_name, file_buff, file_ext_name, meta_list);
            if (slave_file_id != null) {
                System.err.println("slave file_id: " + slave_file_id);
                System.err.println(client.get_file_info1(slave_file_id));
                generated_slave_file_id = ProtoCommon.genSlaveFilename(master_file_id, prefix_name, file_ext_name);
                if (!generated_slave_file_id.equals(slave_file_id)) {
                    System.err.println("generated slave file: " + generated_slave_file_id + "\n != returned slave file: " + slave_file_id);
                }
            }
            if ((errno = client.delete_file1(file_id)) == 0) {
                System.err.println("Delete file success");
            } else {
                System.err.println("Delete file fail, error no: " + errno);
            }
            file_id = client.upload_file1(local_filename, null, meta_list);
            if (file_id != null) {
                System.err.println("file_id: " + file_id);
                System.err.println(client.get_file_info1(file_id));
                InetSocketAddress inetSockAddr = trackerServer.getInetSocketAddress();
                String file_url = "http://" + inetSockAddr.getAddress().getHostAddress();
                if (ClientGlobal.g_tracker_http_port != 80) {
                    file_url = file_url + ":" + ClientGlobal.g_tracker_http_port;
                }
                file_url = file_url + "/" + file_id;
                if (ClientGlobal.g_anti_steal_token) {
                    int ts = (int)(System.currentTimeMillis() / 1000L);
                    String token = ProtoCommon.getToken(file_id, ts, ClientGlobal.g_secret_key);
                    file_url = file_url + "?token=" + token + "&ts=" + ts;
                }
                System.err.println("file url: " + file_url);
                errno = client.download_file1(file_id, 0L, 0L, "c:\\" + file_id.replaceAll("/", "_"));
                if (errno == 0) {
                    System.err.println("Download file success");
                } else {
                    System.err.println("Download file fail, error no: " + errno);
                }
                errno = client.download_file1(file_id, new DownloadFileWriter("c:\\" + file_id.replaceAll("/", "-")));
                if (errno == 0) {
                    System.err.println("Download file success");
                } else {
                    System.err.println("Download file fail, error no: " + errno);
                }
                master_file_id = file_id;
                prefix_name = "-part2";
                file_ext_name = null;
                slave_file_id = client.upload_file1(master_file_id, prefix_name, local_filename, file_ext_name, meta_list);
                if (slave_file_id != null) {
                    System.err.println("slave file_id: " + slave_file_id);
                    System.err.println(client.get_file_info1(slave_file_id));
                    generated_slave_file_id = ProtoCommon.genSlaveFilename(master_file_id, prefix_name, file_ext_name);
                    if (!generated_slave_file_id.equals(slave_file_id)) {
                        System.err.println("generated slave file: " + generated_slave_file_id + "\n != returned slave file: " + slave_file_id);
                    }
                }
            }
            File f = new File(local_filename);
            int nPos = local_filename.lastIndexOf(46);
            file_ext_name = nPos > 0 && local_filename.length() - nPos <= 7 ? local_filename.substring(nPos + 1) : null;
            file_id = client.upload_file1(null, f.length(), new UploadLocalFileSender(local_filename), file_ext_name, meta_list);
            if (file_id != null) {
                System.out.println("file id: " + file_id);
                System.out.println(client.get_file_info1(file_id));
                master_file_id = file_id;
                prefix_name = "-part3";
                slave_file_id = client.upload_file1(master_file_id, prefix_name, f.length(), new UploadLocalFileSender(local_filename), file_ext_name, meta_list);
                if (slave_file_id != null) {
                    System.err.println("slave file_id: " + slave_file_id);
                    generated_slave_file_id = ProtoCommon.genSlaveFilename(master_file_id, prefix_name, file_ext_name);
                    if (!generated_slave_file_id.equals(slave_file_id)) {
                        System.err.println("generated slave file: " + generated_slave_file_id + "\n != returned slave file: " + slave_file_id);
                    }
                }
            } else {
                System.err.println("Upload file fail, error no: " + errno);
            }
            if ((storageServer = tracker.getFetchStorage1(trackerServer, file_id)) == null) {
                System.out.println("getFetchStorage fail, errno code: " + tracker.getErrorCode());
                return;
            }
            System.out.println("active test to storage server: " + ProtoCommon.activeTest(storageServer.getSocket()));
            storageServer.close();
            System.out.println("active test to tracker server: " + ProtoCommon.activeTest(trackerServer.getSocket()));
            trackerServer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

