/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.test;

import java.io.File;
import java.net.InetSocketAddress;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.ServerInfo;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdfs.test.DownloadFileWriter;
import org.csource.fastdfs.test.UploadLocalFileSender;

public class TestAppender {
    private TestAppender() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Error: Must have 2 parameters, one is config filename, the other is the local filename to upload");
            return;
        }
        System.out.println("java.version=" + System.getProperty("java.version"));
        String conf_filename = args[0];
        String local_filename = args[1];
        try {
            int k;
            ClientGlobal.init(conf_filename);
            System.out.println("network_timeout=" + ClientGlobal.g_network_timeout + "ms");
            System.out.println("charset=" + ClientGlobal.g_charset);
            TrackerClient tracker = new TrackerClient();
            TrackerServer trackerServer = tracker.getConnection();
            StorageServer storageServer = null;
            StorageClient client = new StorageClient(trackerServer, storageServer);
            NameValuePair[] meta_list = new NameValuePair[]{new NameValuePair("width", "800"), new NameValuePair("heigth", "600"), new NameValuePair("bgcolor", "#FFFFFF"), new NameValuePair("author", "Mike")};
            byte[] file_buff = "this is a test".getBytes(ClientGlobal.g_charset);
            System.out.println("file length: " + file_buff.length);
            String group_name = null;
            StorageServer[] storageServers = tracker.getStoreStorages(trackerServer, group_name);
            if (storageServers == null) {
                System.err.println("get store storage servers fail, error code: " + tracker.getErrorCode());
            } else {
                System.err.println("store storage servers count: " + storageServers.length);
                for (k = 0; k < storageServers.length; ++k) {
                    System.err.println(k + 1 + ". " + storageServers[k].getInetSocketAddress().getAddress().getHostAddress() + ":" + storageServers[k].getInetSocketAddress().getPort());
                }
                System.err.println("");
            }
            long startTime = System.currentTimeMillis();
            String[] results = client.upload_appender_file(file_buff, "txt", meta_list);
            System.out.println("upload_appender_file time used: " + (System.currentTimeMillis() - startTime) + " ms");
            if (results == null) {
                System.err.println("upload file fail, error code: " + client.getErrorCode());
                return;
            }
            group_name = results[0];
            String remote_filename = results[1];
            System.err.println("group_name: " + group_name + ", remote_filename: " + remote_filename);
            System.err.println(client.get_file_info(group_name, remote_filename));
            ServerInfo[] servers = tracker.getFetchStorages(trackerServer, group_name, remote_filename);
            if (servers == null) {
                System.err.println("get storage servers fail, error code: " + tracker.getErrorCode());
            } else {
                System.err.println("storage servers count: " + servers.length);
                for (k = 0; k < servers.length; ++k) {
                    System.err.println(k + 1 + ". " + servers[k].getIpAddr() + ":" + servers[k].getPort());
                }
                System.err.println("");
            }
            meta_list = new NameValuePair[]{new NameValuePair("width", "1024"), new NameValuePair("heigth", "768"), new NameValuePair("bgcolor", "#000000"), new NameValuePair("title", "Untitle")};
            startTime = System.currentTimeMillis();
            int errno = client.set_metadata(group_name, remote_filename, meta_list, (byte)77);
            System.out.println("set_metadata time used: " + (System.currentTimeMillis() - startTime) + " ms");
            if (errno == 0) {
                System.err.println("set_metadata success");
            } else {
                System.err.println("set_metadata fail, error no: " + errno);
            }
            meta_list = client.get_metadata(group_name, remote_filename);
            if (meta_list != null) {
                for (int i = 0; i < meta_list.length; ++i) {
                    System.out.println(meta_list[i].getName() + " " + meta_list[i].getValue());
                }
            }
            startTime = System.currentTimeMillis();
            file_buff = client.download_file(group_name, remote_filename);
            System.out.println("download_file time used: " + (System.currentTimeMillis() - startTime) + " ms");
            if (file_buff != null) {
                System.out.println("file length:" + file_buff.length);
                System.out.println(new String(file_buff));
            }
            file_buff = "this is a slave buff".getBytes(ClientGlobal.g_charset);
            String appender_filename = remote_filename;
            String file_ext_name = "txt";
            startTime = System.currentTimeMillis();
            errno = client.append_file(group_name, appender_filename, file_buff);
            System.out.println("append_file time used: " + (System.currentTimeMillis() - startTime) + " ms");
            if (errno == 0) {
                System.err.println(client.get_file_info(group_name, appender_filename));
            } else {
                System.err.println("append file fail, error no: " + errno);
            }
            startTime = System.currentTimeMillis();
            errno = client.delete_file(group_name, remote_filename);
            System.out.println("delete_file time used: " + (System.currentTimeMillis() - startTime) + " ms");
            if (errno == 0) {
                System.err.println("Delete file success");
            } else {
                System.err.println("Delete file fail, error no: " + errno);
            }
            results = client.upload_appender_file(local_filename, null, meta_list);
            if (results != null) {
                group_name = results[0];
                remote_filename = results[1];
                String file_id = group_name + "/" + remote_filename;
                InetSocketAddress inetSockAddr = trackerServer.getInetSocketAddress();
                String file_url = "http://" + inetSockAddr.getAddress().getHostAddress();
                if (ClientGlobal.g_tracker_http_port != 80) {
                    file_url = file_url + ":" + ClientGlobal.g_tracker_http_port;
                }
                file_url = file_url + "/" + file_id;
                if (ClientGlobal.g_anti_steal_token) {
                    int ts = (int)(System.currentTimeMillis() / 1000L);
                    String token = ProtoCommon.getToken(file_id, ts, ClientGlobal.g_secret_key);
                    file_url = file_url + "?token=" + token + "&ts=" + ts;
                }
                System.err.println("group_name: " + group_name + ", remote_filename: " + remote_filename);
                System.err.println(client.get_file_info(group_name, remote_filename));
                System.err.println("file url: " + file_url);
                errno = client.download_file(group_name, remote_filename, 0L, 0L, "c:\\" + remote_filename.replaceAll("/", "_"));
                if (errno == 0) {
                    System.err.println("Download file success");
                } else {
                    System.err.println("Download file fail, error no: " + errno);
                }
                errno = client.download_file(group_name, remote_filename, 0L, 0L, new DownloadFileWriter("c:\\" + remote_filename.replaceAll("/", "-")));
                if (errno == 0) {
                    System.err.println("Download file success");
                } else {
                    System.err.println("Download file fail, error no: " + errno);
                }
                appender_filename = remote_filename;
                file_ext_name = null;
                startTime = System.currentTimeMillis();
                errno = client.append_file(group_name, appender_filename, local_filename);
                System.out.println("append_file time used: " + (System.currentTimeMillis() - startTime) + " ms");
                if (errno == 0) {
                    System.err.println(client.get_file_info(group_name, appender_filename));
                } else {
                    System.err.println("append file fail, error no: " + errno);
                }
            }
            File f = new File(local_filename);
            int nPos = local_filename.lastIndexOf(46);
            file_ext_name = nPos > 0 && local_filename.length() - nPos <= 7 ? local_filename.substring(nPos + 1) : null;
            results = client.upload_appender_file(null, f.length(), new UploadLocalFileSender(local_filename), file_ext_name, meta_list);
            if (results != null) {
                group_name = results[0];
                remote_filename = results[1];
                System.out.println("group name: " + group_name + ", remote filename: " + remote_filename);
                System.out.println(client.get_file_info(group_name, remote_filename));
                appender_filename = remote_filename;
                startTime = System.currentTimeMillis();
                errno = client.append_file(group_name, appender_filename, f.length(), new UploadLocalFileSender(local_filename));
                System.out.println("append_file time used: " + (System.currentTimeMillis() - startTime) + " ms");
                if (errno == 0) {
                    System.err.println(client.get_file_info(group_name, appender_filename));
                } else {
                    System.err.println("append file fail, error no: " + errno);
                }
            } else {
                System.err.println("Upload file fail, error no: " + errno);
            }
            storageServer = tracker.getFetchStorage(trackerServer, group_name, remote_filename);
            if (storageServer == null) {
                System.out.println("getFetchStorage fail, errno code: " + tracker.getErrorCode());
                return;
            }
            System.out.println("active test to storage server: " + ProtoCommon.activeTest(storageServer.getSocket()));
            storageServer.close();
            System.out.println("active test to tracker server: " + ProtoCommon.activeTest(trackerServer.getSocket()));
            trackerServer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

