/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.csource.common.IniFileReader;
import org.csource.fastdfs.TrackerGroup;

public class ClientGlobal {
    public static int g_connect_timeout;
    public static int g_network_timeout;
    public static String g_charset;
    public static int g_tracker_http_port;
    public static boolean g_anti_steal_token;
    public static String g_secret_key;
    public static TrackerGroup g_tracker_group;
    public static final int DEFAULT_CONNECT_TIMEOUT = 5;
    public static final int DEFAULT_NETWORK_TIMEOUT = 30;

    private ClientGlobal() {
    }

    public static void init(String conf_filename) throws FileNotFoundException, IOException, Exception {
        String[] szTrackerServers;
        IniFileReader iniReader = new IniFileReader(conf_filename);
        g_connect_timeout = iniReader.getIntValue("connect_timeout", 5);
        if (g_connect_timeout < 0) {
            g_connect_timeout = 5;
        }
        g_connect_timeout *= 1000;
        g_network_timeout = iniReader.getIntValue("network_timeout", 30);
        if (g_network_timeout < 0) {
            g_network_timeout = 30;
        }
        g_network_timeout *= 1000;
        g_charset = iniReader.getStrValue("charset");
        if (g_charset == null || g_charset.length() == 0) {
            g_charset = "ISO8859-1";
        }
        if ((szTrackerServers = iniReader.getValues("tracker_server")) == null) {
            throw new Exception("item \"tracker_server\" in " + conf_filename + " not found");
        }
        InetSocketAddress[] tracker_servers = new InetSocketAddress[szTrackerServers.length];
        for (int i = 0; i < szTrackerServers.length; ++i) {
            String[] parts = szTrackerServers[i].split("\\:", 2);
            if (parts.length != 2) {
                throw new Exception("the value of item \"tracker_server\" is invalid, the correct format is host:port");
            }
            tracker_servers[i] = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        g_tracker_group = new TrackerGroup(tracker_servers);
        g_tracker_http_port = iniReader.getIntValue("http.tracker_http_port", 80);
        g_anti_steal_token = iniReader.getBoolValue("http.anti_steal_token", false);
        if (g_anti_steal_token) {
            g_secret_key = iniReader.getStrValue("http.secret_key");
        }
    }

    public static Socket getSocket(String ip_addr, int port) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(g_network_timeout);
        sock.connect(new InetSocketAddress(ip_addr, port), g_connect_timeout);
        return sock;
    }

    public static Socket getSocket(InetSocketAddress addr) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(g_network_timeout);
        sock.connect(addr, g_connect_timeout);
        return sock;
    }

    public static int getG_connect_timeout() {
        return g_connect_timeout;
    }

    public static void setG_connect_timeout(int connect_timeout) {
        g_connect_timeout = connect_timeout;
    }

    public static int getG_network_timeout() {
        return g_network_timeout;
    }

    public static void setG_network_timeout(int network_timeout) {
        g_network_timeout = network_timeout;
    }

    public static String getG_charset() {
        return g_charset;
    }

    public static void setG_charset(String charset) {
        g_charset = charset;
    }

    public static int getG_tracker_http_port() {
        return g_tracker_http_port;
    }

    public static void setG_tracker_http_port(int tracker_http_port) {
        g_tracker_http_port = tracker_http_port;
    }

    public static boolean getG_anti_steal_token() {
        return g_anti_steal_token;
    }

    public static boolean isG_anti_steal_token() {
        return g_anti_steal_token;
    }

    public static void setG_anti_steal_token(boolean anti_steal_token) {
        g_anti_steal_token = anti_steal_token;
    }

    public static String getG_secret_key() {
        return g_secret_key;
    }

    public static void setG_secret_key(String secret_key) {
        g_secret_key = secret_key;
    }

    public static TrackerGroup getG_tracker_group() {
        return g_tracker_group;
    }

    public static void setG_tracker_group(TrackerGroup tracker_group) {
        g_tracker_group = tracker_group;
    }
}

