/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.consign.util;

import com.ptteng.wealth.consign.model.out.BindingBank;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ConsignmentUtil {
    public static List<String> notBindingBanks(List<BindingBank> bindedBanks, List<String> allBanks) {
        if (CollectionUtils.isEmpty(bindedBanks)) {
            return allBanks;
        }
        ArrayList<String> deleteList = new ArrayList<String>();
        block0: for (String s : allBanks) {
            for (BindingBank bindingBank : bindedBanks) {
                if (!bindingBank.getBankNo().equals(s)) continue;
                deleteList.add(s);
                continue block0;
            }
        }
        allBanks.removeAll(deleteList);
        return allBanks;
    }

    public static BindingBank getBindingBank(List<BindingBank> bindedBanks, String bankno) {
        if (StringUtils.isBlank((CharSequence)bankno) || CollectionUtils.isEmpty(bindedBanks)) {
            return null;
        }
        for (BindingBank bindingBank : bindedBanks) {
            if (bindingBank == null || !bankno.equalsIgnoreCase(bindingBank.getBankNo())) continue;
            return bindingBank;
        }
        return null;
    }

    public static final String getOutterSerialNo() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String insertSpace(String s) {
        StringBuffer sb = new StringBuffer();
        char[] array = s.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i % 4 != 3 || i == array.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getLastNumber4BankAccount(String bankAccount) {
        if (StringUtils.isBlank((CharSequence)bankAccount)) {
            return "";
        }
        String hasSpace = ConsignmentUtil.insertSpace(bankAccount);
        return hasSpace.substring(hasSpace.lastIndexOf(" ") + 1);
    }

    public static List<BindingBank> filtrateBankCards(List<BindingBank> allBankCardList, List<String> bankTypeList) {
        ArrayList<BindingBank> result = new ArrayList<BindingBank>();
        for (BindingBank bindingBank : allBankCardList) {
            if (!bankTypeList.contains(bindingBank.getBankType())) continue;
            result.add(bindingBank);
        }
        return result;
    }
}

