package com.ptteng.wealth.admin.util;

import com.ptteng.wealth.finance.model.account.AccountRecord;
import com.qding.common.util.DataUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by arthur on 16/8/7.
 */
public class AccountRecordUtil {

    public static Map<String, Object> getListParam( String orgName,String mobile,Long updateBeginAt,Long updateEndAt,
                                                    Integer status,Integer type,Boolean count,Boolean swap) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(orgName)) {
            params.put(" org_name & like  ", "'%" + orgName + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            params.put(" mobile  ", "'" + mobile + "'");
        }
        if (DataUtils.isNotNullOrEmpty(updateBeginAt)) {
            params.put(" update_at & >= ", "" + updateBeginAt + "");
        }
        if (DataUtils.isNotNullOrEmpty(updateEndAt)) {
            params.put(" update_at & <= ", "" + updateEndAt + "");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if(swap){
            params.put("type", AccountRecord.TYPE_4);
        }
        else{
            if (DataUtils.isNotNullOrEmpty(type)) {
                params.put("type",  type );
            }
            else{
                params.put(" type & < ", "" + AccountRecord.TYPE_4 + "");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  create_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  accountrecord ");

        return params;
    }
}
