package com.ptteng.wealth.admin.controller.user;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.admin.controller.BaseController;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.PersonApply.PersonApplyUtil;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.PersonApply;
import com.ptteng.wealth.user.model.PersonApplyRecord;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.PersonApplyRecordService;
import com.ptteng.wealth.user.service.PersonApplyService;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * PersonApply  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class PersonApplyController extends BaseController {
    private static final Log log = LogFactory.getLog(PersonApplyController.class);

    @Autowired
    private PersonApplyService personApplyService;

    @Autowired
    private UserService userService;
    @Autowired
    private PersonApplyRecordService personApplyRecordService;
    @Autowired
    private ManagerService managerService;

    @Autowired
    private PersonService personService;

    /**
     * 查询实名认证列表
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/person/apply/", method = RequestMethod.GET)
    public String getPersonApplyList
    (HttpServletRequest request,
     HttpServletResponse response, ModelMap model, Integer page,
     Integer size, Long applyStartAt,
     Long applyEndAt, Long checkStartAt, Long checkEndAt, Integer status, String name, String idNo,String mobile) throws Exception {
        log.info(" page = " + page + " size = " + size + " name = " + name);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> map = PersonApplyUtil.getListParam(applyStartAt, applyEndAt, checkStartAt, checkEndAt, status, name, idNo,mobile, false);
            List<Long> personApplyIds = personApplyService.getIdsByDynamicCondition(PersonApply.class, map, start, size);
            log.info("  personApplyIds  size = " + personApplyIds.size());
            if (personApplyIds.size() > 0) {
                List<PersonApply> personApplyList = personApplyService.getObjectsByIds(personApplyIds);
                List<Long> uIds = new ArrayList<>();
                for (PersonApply personApply : personApplyList) {
                    uIds.add(personApply.getUid());
                }
                log.info(" userid size = " + uIds);
                Map<Long, String> userMobileMap = new HashMap<>();
                if (uIds.size() > 0) {
                    List<User> users = userService.getObjectsByIds(uIds);
                    for (User user : users) {
                        userMobileMap.put(user.getId(), user.getMobile());
                    }
                }
                model.addAttribute("userMobileMap", userMobileMap);
                model.addAttribute("personApplyList", personApplyList);
            }
            Integer totalSize = (personApplyService.getIdsByDynamicCondition(PersonApply.class, map, 0, Integer.MAX_VALUE)).size();
            model.addAttribute("total", totalSize);
            model.addAttribute("code", 0);
            model.addAttribute("totalPage", totalPage(size, totalSize));
            model.addAttribute("page", page);
            model.addAttribute("size", size);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userAccountRelation list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        return "/admin/personApply/json/personApplyListJson";
    }




    /**
     * 查询详细
     *
     * @param request
     * @param response
     * @param model
     * @return {"status":1,"refuseReason":"身份证不清晰"}
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/person/apply/{id}", method = RequestMethod.GET)
    public String getPersonApplyJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        try {
            log.info(" id = " + id);
            PersonApply personApply = personApplyService.getObjectById(id);
            if (null == personApply) {
                model.addAttribute("code", -12000);
                return "/data/json";
            }

            if (null != personApply.getUid()) {
                User user = userService.getObjectById(personApply.getUid());
                if (null != user) {
                    model.addAttribute("mobile", user.getMobile());
                }
            }


            log.info("get personApply data is " + personApply);
            model.addAttribute("code", 0);
            model.addAttribute("personApply", personApply);


            log.info("  personApplyRecordService = " + personApplyRecordService);
            List<Long> recordIds = personApplyRecordService.
                    getPersonApplyRecordIdsByPersonApplyId(id, 0, Integer.MAX_VALUE);
            if (recordIds.size() > 0) {
                List<PersonApplyRecord> recordList = personApplyRecordService.getObjectsByIds(recordIds);
                model.addAttribute("recordList", recordList);


            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get personApply error  ");
            model.addAttribute("code", -1);
        }

        return "/admin/personApply/json/personApplyDetailJson";
    }

    /**
     * 保存审核结果
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status       审核结果
     * @param refuseReason 驳回原因
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/person/apply/{id}", method = RequestMethod.PUT)
    public String updatePersonApplyJson(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer status, String refuseReason) throws Exception {

        log.info("update personApply : id= " + id);
        try {
            Long mid = getUserId(request);
            Manager manager = managerService.getObjectById(mid);
            PersonApply personApply = personApplyService.getObjectById(id);
            if (null == personApply) {
                model.addAttribute("code", -12000);
                return "/data/json";
            }
            if(!PersonApply.STATUS_1.equals(personApply.getStatus())){
                model.addAttribute("code", -2017);
                return "/data/json";
            }

            personApply.setStatus(status);
            personApply.setRefuseReason(refuseReason);
            personApply.setCheckAt(System.currentTimeMillis());
            personApplyService.update(personApply);
            if (PersonApply.STATUS_2.equals(status)) {
                log.info(" check pass ");
                //如果审核通过，设置为已实名认证
                User user = userService.getObjectById(personApply.getUid());
                if (null != user) {
                    log.info(" update user id = " + user.getId());
                    user.setName(personApply.getName());
                    user.setAuthStatus(User.ALREADY_AUTH);
                    Boolean update = userService.update(user);
                    log.info("  update user = " + update);
                }
                Person person = personService.getObjectById(personApply.getUid());
                if (null != person) {
                    log.info(" update person id = " + person.getId());
                    person.setIdNo(personApply.getIdNo());
                    person.setName(personApply.getName());
                    person.setIdBack(personApply.getIdBack());
                    person.setIdFront(personApply.getIdFront());
                    person.setPersonIdImg(personApply.getPersonIdImg());
                    Boolean update = personService.update(person);
                    log.info("  update person  = " + update);
                }
                else{
                    person = new Person();
                    log.info(" insert person id  " );
                    person.setIdNo(personApply.getIdNo());
                    person.setName(personApply.getName());
                    person.setIdBack(personApply.getIdBack());
                    person.setIdFront(personApply.getIdFront());
                    person.setPersonIdImg(personApply.getPersonIdImg());
                    personService.insert(person);
                }
            }

            List<Long> recordIds = personApplyRecordService.getPersonApplyRecordIdsByPersonApplyId(id, 0, Integer.MAX_VALUE);
            Integer count = recordIds.size();
            PersonApplyRecord personApplyRecord = new PersonApplyRecord();
            personApplyRecord.setPersonApplyId(id);
            personApplyRecord.setStatus(status);
            personApplyRecord.setDescription(refuseReason);
            if (count.equals(0)) {
                personApplyRecord.setNumber(1 + "");
            } else {
                personApplyRecord.setNumber((count + 1) + "");
            }
            personApplyRecord.setOperator(manager.getName());
            personApplyRecord.setCreateBy(mid);
            personApplyRecord.setUpdateBy(mid);
            Long recordId = personApplyRecordService.insert(personApplyRecord);
            log.info(" recordId = " + recordId);
            model.addAttribute("code", 0);

            model.addAttribute("personApply", personApply);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update personApply error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/data/json";
    }



}

