package com.ptteng.wealth.admin.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by asus on 2016/11/16.
 */
public class sqlUtil {

    private static final Log log = LogFactory.getLog("sql");

    public static String getDynamicSql(String name, String orderNo, Long uid, String status, Integer type, Integer start, Integer limit) {
        Map<String, Object> debtParams = new HashMap<String, Object>();
        Set<String> debtTables = new HashSet();
        debtTables.add("debtapply");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            debtParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            debtParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            debtParams.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            debtParams.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(name)) {
            debtTables.add("wealth_user.user");
            debtParams.put("debtapply.uid", "user.id ");
            debtParams.put("user.name & like ", "'%" + name + "%'");
        }

        String debtTable = SQLUtil.convertTable(debtTables);
        debtParams.put("@query", " * ");
        debtParams.put("@table", debtTable);
        String debtSql = SQLUtil.convert2Sql(debtParams, 0, Integer.MAX_VALUE);


        Map<String, Object> loanParams = new HashMap<String, Object>();
        Set<String> loanTables = new HashSet();
        loanTables.add("loan_apply");

        if (DataUtils.isNotNullOrEmpty(uid)) {
            loanParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            loanParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            loanParams.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            loanParams.put("status", status);
        }

        if (DataUtils.isNotNullOrEmpty(name)) {
            loanTables.add("wealth_user.user");
            debtParams.put("loan_apply.uid", "user.id ");
            debtParams.put("user.name & like ", "'%" + name + "%'");
        }

        String loanTable = SQLUtil.convertTable(loanTables);
        loanParams.put("@query", " * ");
        loanParams.put("@table", loanTable);
        String loanSql = SQLUtil.convert2Sql(loanParams, 0, Integer.MAX_VALUE);

        String limitSql = " limit " + start + " , " + limit;

        String sql = "SELECT * FROM ((" + debtSql + ") UNION ALL (" + loanSql + ")) as total order by create_at desc" + limitSql;

        return sql;

    }

    public static String getNotDynamicSql(String name, String orderNo, String mobile, Long uid, String status, Integer noTypeA, Integer noTypeB,
                                          Integer noTypeC, Integer noTypeD, Integer debtType, Long createAtStart, Long createAtEnd,
                                          Long repayLineStart, Long repayLineEnd, Integer start, Integer limit) {
        log.info(orderNo + " " + uid + " " + status + " " + noTypeA + " " + noTypeB + " " + noTypeC + " " + noTypeD + " " +
                debtType + " " + createAtStart + " " + createAtEnd + " " + repayLineStart + " " + repayLineEnd + " " + start + " " + limit );

        Map<String, Object> debtParams = new HashMap<String, Object>();
        Set<String> debtTables = new HashSet();
        debtTables.add("debtapply");

        if (DataUtils.isNotNullOrEmpty(name)) {
            debtTables.add("wealth_user.user");
            debtParams.put("debtapply.uid", "user.id ");
            debtParams.put("user.name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(uid)) {
            debtParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            debtParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            debtParams.put("user_mobile", "'" + mobile + "'");
        }
        if (DataUtils.isNotNullOrEmpty(noTypeA)) {
            debtParams.put("debtapply.type & != ", noTypeA);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeB)) {
            debtParams.put("debtapply.type & !=  ", noTypeB);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeC)) {
            debtParams.put("debtapply.type & !=   ", noTypeC);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeD)) {
            debtParams.put("debtapply.type & !=", noTypeD);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            debtParams.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            debtParams.put(" create_at & >= ", "'" + createAtStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            debtParams.put(" create_at & <= ", "'" + createAtEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineStart)) {
//            debtParams.put(" repay_line & >= ", "'" + repayLineStart + "'");
            debtParams.put(" over_at & >= ", "'" + repayLineStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineEnd)) {
//            debtParams.put(" repay_line & <= ", "'" + repayLineEnd + "'");
            debtParams.put(" over_at & <= ", "'" + repayLineEnd + "'");
        }

//        if(2 == debtType){
////            debtParams.put("1", "2");
//            debtParams.put(" order_type ", "2");
//        }
        if (DataUtils.isNotNullOrEmpty(debtType) && 1 == debtType) {
//            debtParams.put("1", "2");
            debtParams.put(" order_type ", "2");
        }

        String debtTable = SQLUtil.convertTable(debtTables);
        debtParams.put("@query", " debtapply.* ");
        debtParams.put("@table", debtTable);
        log.info("debt params : " + debtParams);
        String debtSql = SQLUtil.convert2Sql(debtParams, 0, Integer.MAX_VALUE);


        Map<String, Object> loanParams = new HashMap<String, Object>();
        Set<String> loanTables = new HashSet();
        loanTables.add("loan_apply");

        if (DataUtils.isNotNullOrEmpty(name)) {
            loanTables.add("wealth_user.user");
            loanParams.put("loan_apply.uid", "user.id ");
            loanParams.put("user.name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            loanParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            loanParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            loanParams.put("user_mobile", "'" + mobile + "'");
        }
        if (DataUtils.isNotNullOrEmpty(noTypeA)) {
            loanParams.put("loan_apply.type & !=", noTypeA);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeB)) {
            loanParams.put("loan_apply.type & != ", noTypeB);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeC)) {
            loanParams.put("loan_apply.type & !=  ", noTypeC);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeD)) {
            loanParams.put("loan_apply.type & !=   ", noTypeD);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            loanParams.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            loanParams.put(" create_at & >= ", "'" + createAtStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            loanParams.put(" create_at & <= ", "'" + createAtEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineStart)) {
//            loanParams.put(" repay_line & >= ", "'" + repayLineStart + "'");
            loanParams.put(" over_at & >= ", "'" + repayLineStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineEnd)) {
//            loanParams.put(" repay_line & <= ", "'" + repayLineEnd + "'");
            loanParams.put(" over_at & <= ", "'" + repayLineEnd + "'");
        }
        if(DataUtils.isNotNullOrEmpty(debtType) && 2 == debtType){
//            debtParams.put("1", "2");
            loanParams.put(" order_type & in ", "(1,3)");
        }

        String loanTable = SQLUtil.convertTable(loanTables);
        loanParams.put("@query", " loan_apply.* ");
        loanParams.put("@table", loanTable);
        String loanSql = SQLUtil.convert2Sql(loanParams, 0, Integer.MAX_VALUE);

        String limitSql = " limit " + start + " , " + limit;

        String sql = "";
        if (DataUtils.isNotNullOrEmpty(debtType) && 1 == debtType) {
            sql = "SELECT * FROM (" + debtSql + ") as total order by create_at desc" + limitSql;
        } else if (DataUtils.isNotNullOrEmpty(debtType) && 2 == debtType) {
            sql = "SELECT * FROM (" + loanSql + ") as total order by create_at desc" + limitSql;
        } else {
            sql = "SELECT * FROM ((" + debtSql + ") UNION ALL (" + loanSql + ")) as total order by create_at desc" + limitSql;
        }

        return sql;

    }

    public static String getNotDynamicCountSql(String name, String orderNo, String mobile, Long uid, String status, Integer noTypeA, Integer noTypeB,
                                          Integer noTypeC, Integer noTypeD, Integer debtType, Long createAtStart, Long createAtEnd,
                                          Long repayLineStart, Long repayLineEnd/*, Integer start, Integer limit*/) {
        log.info(orderNo + " " + uid + " " + status + " " + noTypeA + " " + noTypeB + " " + noTypeC + " " + noTypeD + " " +
                debtType + " " + createAtStart + " " + createAtEnd + " " + repayLineStart + " " + repayLineEnd /*+ " " + start + " " + limit */);

        Map<String, Object> debtParams = new HashMap<String, Object>();
        Set<String> debtTables = new HashSet();
        debtTables.add("debtapply");

        if (DataUtils.isNotNullOrEmpty(name)) {
            debtTables.add("wealth_user.user");
            debtParams.put("debtapply.uid", "user.id ");
            debtParams.put("user.name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(uid)) {
            debtParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            debtParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            debtParams.put("user_mobile", "'" + mobile + "'");
        }
        if (DataUtils.isNotNullOrEmpty(noTypeA)) {
            debtParams.put("debtapply.type & != ", noTypeA);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeB)) {
            debtParams.put("debtapply.type & !=  ", noTypeB);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeC)) {
            debtParams.put("debtapply.type & !=   ", noTypeC);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeD)) {
            debtParams.put("debtapply.type & !=", noTypeD);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            debtParams.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            debtParams.put(" create_at & >= ", "'" + createAtStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            debtParams.put(" create_at & <= ", "'" + createAtEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineStart)) {
//            debtParams.put(" repay_line & >= ", "'" + repayLineStart + "'");
            debtParams.put(" over_at & >= ", "'" + repayLineStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineEnd)) {
//            debtParams.put(" repay_line & <= ", "'" + repayLineEnd + "'");
            debtParams.put(" over_at & <= ", "'" + repayLineEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(debtType) && 1 == debtType) {
//            debtParams.put("1", "2");
            debtParams.put(" order_type ", "2");
        }

        String debtTable = SQLUtil.convertTable(debtTables);
        debtParams.put("@query", " debtapply.* ");
        debtParams.put("@table", debtTable);
        log.info("debt params : " + debtParams);
        String debtSql = SQLUtil.convert2Sql(debtParams, 0, Integer.MAX_VALUE);


        Map<String, Object> loanParams = new HashMap<String, Object>();
        Set<String> loanTables = new HashSet();
        loanTables.add("loan_apply");

        if (DataUtils.isNotNullOrEmpty(name)) {
            loanTables.add("wealth_user.user");
            loanParams.put("loan_apply.uid", "user.id ");
            loanParams.put("user.name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(uid)) {
            loanParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            loanParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(mobile)) {
            loanParams.put("user_mobile", "'" + mobile + "'");
        }
        if (DataUtils.isNotNullOrEmpty(noTypeA)) {
            loanParams.put("loan_apply.type & !=", noTypeA);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeB)) {
            loanParams.put("loan_apply.type & != ", noTypeB);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeC)) {
            loanParams.put("loan_apply.type & !=  ", noTypeC);
        }
        if (DataUtils.isNotNullOrEmpty(noTypeD)) {
            loanParams.put("loan_apply.type & !=   ", noTypeD);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            loanParams.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(createAtStart)) {
            loanParams.put(" create_at & >= ", "'" + createAtStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(createAtEnd)) {
            loanParams.put(" create_at & <= ", "'" + createAtEnd + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineStart)) {
//            loanParams.put(" repay_line & >= ", "'" + repayLineStart + "'");
            loanParams.put(" over_at & >= ", "'" + repayLineStart + "'");
        }
        if (DataUtils.isNotNullOrEmpty(repayLineEnd)) {
//            loanParams.put(" repay_line & <= ", "'" + repayLineEnd + "'");
            loanParams.put(" over_at & <= ", "'" + repayLineEnd + "'");
        }
        if(DataUtils.isNotNullOrEmpty(debtType) && 2 == debtType){
//            debtParams.put("1", "2");
            loanParams.put(" order_type & in ", "(1,3)");
        }

        String loanTable = SQLUtil.convertTable(loanTables);
        loanParams.put("@query", " loan_apply.* ");
        loanParams.put("@table", loanTable);
        String loanSql = SQLUtil.convert2Sql(loanParams, 0, Integer.MAX_VALUE);

//        String limitSql = " limit " + start + " , " + limit;

        String sql = "";
        if (DataUtils.isNotNullOrEmpty(debtType) && 1 == debtType) {
            sql = "SELECT count(*) FROM (" + debtSql + ") as total order by create_at desc";
        } else if (DataUtils.isNotNullOrEmpty(debtType) && 2 == debtType) {
            sql = "SELECT count(*) FROM (" + loanSql + ") as total order by create_at desc";
        } else {
            sql = "SELECT count(*) FROM ((" + debtSql + ") UNION ALL (" + loanSql + ")) as total order by create_at desc";
        }

        return sql;

    }

}
