package com.ptteng.wealth.admin.util;

import com.gemantic.common.util.MyTimeUtil;

import java.text.SimpleDateFormat;

/**
 * Created by asus on 2016/11/3.
 */
public class WeekCountUtil {

    public final static Long HOURS_TIME = 60*60*1000L;

    public static  Integer weekCalculate (Long date){
        SimpleDateFormat df;

        df = new SimpleDateFormat("yyyy-MM-dd");
        String time = df.format(date);
        String[] week = time.split("-");

            /*
            * 以2049年10月1日（100周年国庆）为例，用蔡勒（Zeller）公式进行计算，过程如下：
            * 蔡勒（Zeller）公式：w=y+[y/4]+[c/4]-2c+[26(m+1)/10]+d-1
            * =49+[49/4]+[20/4]-2×20+[26× (10+1)/10]+1-1
            * =49+[12.25]+5-40+[28.6] =49+12+5-40+28 =54 (除以7余5)
            * 即2049年10月1日（100周年国庆）是星期5。
            */
        int c = Integer.valueOf(week[0].substring(0, 1));
        int y = Integer.valueOf(week[0].substring(2, 3));
        int month = Integer.valueOf(week[1]);
            // int weekIndex=y+(y/4)+(c/4)-2*c+(26*(month+1)/10)+day-1;
        if (month > 3 && month <= 14) {
        } else {
            y = y - 1;
            month = month + 12;
        }
        int day = Integer.valueOf(week[2]);
        int weekIndex = y + (y / 4) + (c / 4) - 2 * c + (26 * (month + 1) / 10) + day - 1;
        if (weekIndex < 0) {
            weekIndex = weekIndex * (-1);
        } else {
            weekIndex = weekIndex % 7;
        }

        return weekIndex;
    }


    //判断当前时间在3点前后
    public static Boolean timeCalculate (Long date){

        if(null == date){
            return null;
        }

        Boolean result = false;

        Long zeroDate = MyTimeUtil.getStartTime(date);
        Long threePm = 15 * HOURS_TIME + zeroDate;
        if(date < threePm){
            result = true;
        }

        return result;
    }
}
