package com.ptteng.wealth.admin.util;

//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

import com.gemantic.common.util.TokenUtils;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.common.util.http.cookie.MD5Util;
import com.qding.common.util.http.cookie.RequestUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CookieUtil {
    private static Log log = LogFactory.getLog(CookieUtil.class);
    public Integer cookieMaxAge = Integer.valueOf(60*30);
    private String home = "www.lcyff.com";
    private String domain = ".lcyff.com";
    private String loginName = "";
    private Integer   maxAge = 0;


    public static final String verifyCode = "verifyCode";
    public static final String USER_CODE = "userCode";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "userName";
    public static final String SAVE_TIME = "saveTime";
    public static final String KAPTCHA = "Kaptcha";
    public static final String CURRENT_VISITOR = "currentVisitor";
    public static final String REFERER = "referer";
    public static final Long NONLOGIN_USER_ID = Long.valueOf(-1L);

    public CookieUtil() {
    }

    public void setIdentity(HttpServletRequest request, HttpServletResponse response, String userName, Long userId) {
        if(null != this.cookieMaxAge && 0 != this.cookieMaxAge.intValue()) {
            IdentityUtil.setIdentity(request, response, this.home, userName, userId, this.cookieMaxAge.intValue());
        } else {
            IdentityUtil.setIdentity(request, response, this.home, userName, userId);
        }

    }

    public void setIdentity(HttpServletRequest request, HttpServletResponse response, Map<String, String> params, Long userId) {
        if(null != this.cookieMaxAge && 0 != this.cookieMaxAge.intValue()) {
            IdentityUtil.setIdentity(request, response, this.home, params, userId, this.cookieMaxAge.intValue());
        } else {
            IdentityUtil.setIdentity(request, response, this.home, params, userId);
        }

    }

    public Map getIdentity(HttpServletRequest request, HttpServletResponse response) {
        Map userMap = IdentityUtil.getIdentity(request, this.home);
        if(null != userMap) {
            ;
        }

        return userMap;
    }

    public String getKeyIdentity(HttpServletRequest request, String key) {
        Map map = this.getIdentity(request);
        return (String)map.get(key);
    }

    public Map<String, String> getIdentity(HttpServletRequest request) {
        Object userMap = IdentityUtil.getMapFromCookie(request, this.home);
        if(null == userMap) {
            userMap = new HashMap();
        }

        return (Map)userMap;
    }

    public void deleteIdentity(HttpServletRequest request, HttpServletResponse response) {
        IdentityUtil.deleteIdentity(request, response, this.home);
    }

    public Long getID(HttpServletRequest request, HttpServletResponse response) {
        Cookie c = RequestUtil.getCookie(request, this.getLoginName());
        if(null != c){
            String tokenValue = TokenUtils.parseToken(c.getValue().replace("\"","")).trim();
            return  Long.parseLong(tokenValue);
        }
        return  null;
    }

    public Long getID(HttpServletRequest request) {
        Cookie c = RequestUtil.getCookie(request, this.getLoginName());
        if(null != c && c.getValue().trim().length()>1){
            String tokenValue = TokenUtils.parseToken(c.getValue().replace("\"","")).trim();
            return  Long.parseLong(tokenValue);
        }
        return  null;
    }

    public String getName(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.getIdentity(request, response);
        return map != null && !StringUtils.isBlank(map.get("userName").toString())?(String)map.get("userName"):null;
    }

    public void setIdentity(HttpServletRequest request, HttpServletResponse response, String kaptcha) {
        String value = null;

        try {
            value = MD5Util.getMd5Sum(kaptcha);
        } catch (NoSuchAlgorithmException var6) {
            log.error("got error when getMD5", var6);
            return;
        }

        RequestUtil.setCookie(response, "verifyCode", value, -1, this.domain, (String) null);
    }

    public String getKaptchaIdentity(HttpServletRequest request) {
        String capText = null;
        Cookie c = RequestUtil.getCookie(request, "verifyCode");
        if(c != null) {
            capText = c.getValue();
        }

        return capText;
    }


    private Boolean isExpire(Long value) {
        Calendar c = Calendar.getInstance();

        try {
            Long e = Long.valueOf(c.getTimeInMillis() - value.longValue());
            Integer days = Integer.valueOf((int)(e.longValue() / 1000L));
            if(days.intValue() > this.cookieMaxAge.intValue()) {
                return Boolean.valueOf(true);
            }
        } catch (Exception var5) {
            log.error("got error when determine cookie isExpire", var5);
            return Boolean.valueOf(true);
        }

        return Boolean.valueOf(false);
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public Integer getMaxAge() {
        return maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }
    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}
