package com.ptteng.wealth.admin.controller.account;

import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.admin.controller.BaseController;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.BalanceInquiryIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.BalanceInquiryOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.finance.client.account.AccountRecordSCAClient;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.AccountRecord;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.account.AccountRecordService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.util.Constant;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * UserAccountRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserAccountRelationController extends BaseController {
    private static final Log    log = LogFactory.getLog(UserAccountRelationController.class);

    //调账的LOG
    private static final Log swapLog = LogFactory.getLog("swaplog");
    private static final Log swapExecLog = LogFactory.getLog("swag_exec_log");
    private static final Log upLog = LogFactory.getLog("uplog");
    private static final Log upExecLog = LogFactory.getLog("up_exec_log");

    @Autowired
    private UserAccountRelationService userAccountRelationService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private AccountRecordService accountRecordService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private FundHistoryService fundHistoryService;


    /**
     * 获取机构的基本信息，主要是上账和调账时，获取组织机构代码和账户名称用
     */
    @RequestMapping(value = "/a/u/user/account/{userId}", method = RequestMethod.GET)
    public String info(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model, @PathVariable Long userId) throws Exception {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        User user = userService.getObjectById(userId);
        Organization organization = organizationService.getObjectById(userId);
        List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
        if (null != relations) {
            List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(userId, 0, Integer.MAX_VALUE);
            relations = userAccountRelationService.getObjectsByIds(relationIds);
        }

        if(null == organization){
            organization = new Organization();
            organization.setName(user.getName());
            organization.setType(2);
        }


        objMap.put("obj", organization);
        objMap.put("code", 0);
        objMap.put("accounts", relations);
        writeConent(response.getWriter(), response, true, 200, null, null, objMap, null);
        return null;
    }

    /**
     * 获取机构的详细信息
     */
    @RequestMapping(value = "/a/u/user/account/{userId}/detail")
    public String detail(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, @PathVariable Long userId) throws Exception {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        Organization organization = organizationService.getObjectById(userId);
        User user = userService.getObjectById(userId);
        Fund fund = fundService.getObjectById(userId);
        List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
        if (null != relations) {
            List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(userId, 0, Integer.MAX_VALUE);
            relations = userAccountRelationService.getObjectsByIds(relationIds);
        }
        BalanceInquiryOut balance = null;
        try {
            BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
            balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
            balanceInquiryIn.setFundAccount(user.getFundAccount());
            balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            balanceInquiryIn.setUserId(user.getId() + "");
            if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                Person person = personService.getObjectById(user.getId());
                balanceInquiryIn.setCertType("0");
                balanceInquiryIn.setCertId(person.getIdNo());
                balanceInquiryIn.setUserNameText(user.getName());
            } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                balanceInquiryIn.setCertType(Constant.IDKIND);
                balanceInquiryIn.setUserNameText(organization.getName());
                balanceInquiryIn.setCertId(organization.getUseCertId());
            }
            balanceInquiryIn.setPassword(user.getPayPwd());
            balanceInquiryIn.setGtTradePassword(user.getPayPwd());
            balanceInquiryIn.setIfQueryTransitmAmt("1");
            balance = consignmentService.getBalance(balanceInquiryIn);
            log.info(balance);
        } catch (Exception e) {
            log.info(e.getMessage());
        }

        List<BindingBank> resultBindingLs = new ArrayList<BindingBank>();
        try {
            BindingBankIn bindingBankIn = new BindingBankIn();
            bindingBankIn.setFunctionId(9534);
            bindingBankIn.setUserId(user.getId().toString());
            bindingBankIn.setFundAccount(user.getFundAccount());
            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
            for (BindingBank bindingBank : bindingBanks) {
                if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT")) {
                    continue;
                }
                resultBindingLs.add(bindingBank);
                log.info("Binding : " + bindingBank);
            }
        } catch (Throwable t) {
            t.printStackTrace(System.out);
        }

        objMap.put("organization", organization);
        objMap.put("code", 0);

        if (null != balance) {
            objMap.put("wayFund", balance.getRedeeTransitmAmt());
            objMap.put("balance", balance.getTotalAmt());
        } else {
            objMap.put("wayFund", 0);
            objMap.put("balance", 0);
        }
        objMap.put("fund", fund);
        objMap.put("relations", relations);
        objMap.put("bindingBanks", resultBindingLs);
        writeConent(response.getWriter(), response, true, 200, null, null, objMap, null);
        return "";
    }


    /**
     * 获取用户详情
     *
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/person/account/{uid}/detail", method = RequestMethod.GET)
    public String searchUser(ModelMap model, HttpServletResponse response, @PathVariable Long uid) throws Exception {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        // 这里的name是单元name
        log.info("get  user detail  data : " + uid);
        try {
            User user = this.userService.getObjectById(uid);
            if (user == null) {
                model.addAttribute("code", -2000);
                return "/data/json";
            } else {
                Person person = personService.getObjectById(user.getId());
                List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
                List<Long> accountIds = accountService.getAccountIds(0, Integer.MAX_VALUE);
                List<Account> accounts = accountService.getObjectsByIds(accountIds);

                List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(user.getId(), 0, Integer.MAX_VALUE);
                relations = userAccountRelationService.getObjectsByIds(relationIds);

                if (accounts.size() != relations.size()) {
                    for (Account account : accounts) {
                        int find = 0;
                        for (UserAccountRelation userAccountRelation : relations) {
                            if (account.getAccCode().equals(userAccountRelation.getAccountCode())) {
                                find = 1;
                            }
                        }
                        if (find == 0) {
                            UserAccountRelation userAccountRelation = new UserAccountRelation();
                            userAccountRelation.setAccountCode(account.getAccCode());
                            userAccountRelation.setAccountId(account.getId());
                            userAccountRelation.setAccountName(account.getName());
                            userAccountRelation.setUserId(uid);
                            userAccountRelation.setMoney(new BigDecimal(0));
                            userAccountRelation.setCreateAt(System.currentTimeMillis());
                            userAccountRelation.setCreateBy(0l);
                            userAccountRelation.setUpdateAt(System.currentTimeMillis());
                            userAccountRelation.setUpdateBy(0l);
                            userAccountRelationService.insert(userAccountRelation);
                        }
                    }
                    relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(user.getId(), 0, Integer.MAX_VALUE);
                    relations = userAccountRelationService.getObjectsByIds(relationIds);
                }

                objMap.put("code", 0);
                objMap.put("user", user);
                objMap.put("person", person);
                objMap.put("accounts", relations);
                writeConent(response.getWriter(), response, true, 200, null, null, objMap, null);
                return null;
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get  user error " + uid);
            model.addAttribute("code", -100000);
        }

        return "/wealth-admin-web/user/json/accountUserDetailJson";
    }


    /**
     * 生成调账申请记录
     */
    @RequestMapping(value = "/a/u/user/account/{userId}/{from}/{to}/{amount}/{serialNo}")
    public String swapMoney(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model,
                            @PathVariable Long userId, @PathVariable String from,
                            @PathVariable String to, @PathVariable Double amount, @PathVariable String serialNo, String comments) throws Exception {
        int code = 0;
        swapLog.info("======================================================================");
        swapLog.info(" USER : " + userId + "   FROM : " + from + "  TO : " + to + "  AMOUNT : " + amount + " SERIAL NO : " + serialNo + " COMMENT : " + comments);
        Long fromId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(userId, from);
        swapLog.info(" FROMID: " + fromId);
        Long toId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(userId, to);
        swapLog.info(" TOID: " + toId);
        if (null == fromId) {
            UserAccountRelation relation = new UserAccountRelation();
            Long accountId = accountService.getObjectByCode(from);
            relation.setAccountId(accountId);
            relation.setAccountCode(from);
            relation.setUserId(userId);
            fromId = userAccountRelationService.insert(relation);
            swapLog.info(userId + " userID and accountCode " + from + " not exist ,so create it ,id is : " + fromId);
        }
        if(null == toId){
            UserAccountRelation relation = new UserAccountRelation();
            Long accountId = accountService.getObjectByCode(to);
            relation.setAccountId(accountId);
            relation.setAccountCode(to);
            relation.setUserId(userId);
            toId = userAccountRelationService.insert(relation);
            swapLog.info(userId + " userID and accountCode " + from + " not exist ,so create it ,id is : " + toId);
        }

        UserAccountRelation fromAccountRelation = userAccountRelationService.getObjectById(fromId);
        swapLog.info(" money: " + fromAccountRelation.getMoney());
        if (fromAccountRelation.getMoney().doubleValue() >= amount.doubleValue()) {
            code = userAccountRelationService.swapMoney(fromId, toId, amount, serialNo, getUserId(request), comments);
        } else {
            code = UserAccountRelation.SWAP_NO_MONEY;
        }
        swapLog.info(" RESULT: " + code);

        model.addAttribute("id", getUserId(request));
        model.addAttribute("code", code);
        swapLog.info("==================================  END ====================================");

        return "/data/json";
    }

    /**
     * 实际执行转账
     */
    @RequestMapping(value = "/a/u/user/account/exec/{recordId}")
    public String execMoney(HttpServletRequest request, ModelMap model, @PathVariable Long recordId, Integer status, String refuseReason) throws Exception {
        int code = 0;
        swapExecLog.info("======================================================================");
        swapExecLog.info(" EXEC recordId : " + recordId);
        Long userId = getUserId(request);
        User user = new User();
        User targetUser = new User();
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal targetMoney = BigDecimal.ZERO;
        AccountRecord accountRecord = accountRecordService.getObjectById(recordId);
        if (null == accountRecord) {
            code = -9103;
        } else {
            Long uid = accountRecord.getUserId();
            log.info("uid : " + uid);

            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountId(uid, accountRecord.getAccountId());
            swapExecLog.info("userAccount id : " + userAccountId);

            Long targetAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountId(uid, accountRecord.getToAccountId());
            swapExecLog.info("targetAccount id : " + targetAccountId);

            UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
            UserAccountRelation targetAccountRelation = userAccountRelationService.getObjectById(targetAccountId);
            if(null == userAccountRelation || null == targetAccountRelation){
                code = -2010;
            }else {
                Long targetUid = targetAccountRelation.getUserId();
                if(null == uid || null == targetUid){
                    code = -2000;
                }else {
                    user = userService.getObjectById(uid);
                    swapExecLog.info("user : " + user);

                    targetUser = userService.getObjectById(targetUid);
                    swapExecLog.info("target user : " + targetUser);
                }

                money = userAccountRelation.getMoney();
                swapExecLog.info("user money : " + money);

                targetMoney = targetAccountRelation.getMoney();
                swapExecLog.info("target money : " + targetMoney);
            }

            if (status.equals(AccountRecord.STATUS_2)) {
                code = userAccountRelationService.execMoney(recordId, userId);

                if(code == 0){
                    //记录流水操作
                    BigDecimal finalMoney = money.subtract(accountRecord.getAddMoney());
                    swapExecLog.info("swapExec over , final money is : " + finalMoney);
                    Long id = fundHistoryService.insertTransaction(null, user, FundHistory.TYPE_Draw_Account, FundHistory.DETAIL_Draw, userAccountId,
                            accountRecord.getAddMoney(), null, FundHistory.FLAG_Out, FundHistory.STATUS_Pass, null, money, finalMoney);
                    swapExecLog.info("insert transaction success : id " + id);


                    BigDecimal targetFinalMoney = targetMoney.add(accountRecord.getAddMoney());
                    swapExecLog.info("swapExec over , final target money is : " + targetFinalMoney);
                    Long targetId = fundHistoryService.insertTransaction(null, targetUser, FundHistory.TYPE_Charge_Account, FundHistory.DETAIL_Charge,
                            targetAccountId, accountRecord.getAddMoney(), null, FundHistory.FLAG_In, FundHistory.STATUS_Pass, null, targetMoney, targetFinalMoney);
                    swapExecLog.info("insert transaction success : id " + targetId);
                }


            } else if (status.equals(AccountRecord.STATUS_3)) {
                accountRecord.setStatus(AccountRecord.STATUS_3);
                accountRecord.setRefuseReason(refuseReason);
                accountRecord.setUpdateBy(userId);
                accountRecord.setUpdateAt(System.currentTimeMillis());
                accountRecordService.update(accountRecord);
            }


        }
        model.addAttribute("id", getUserId(request));
        model.addAttribute("code", code);
        swapExecLog.info("==================================  END ====================================");
        return "/data/json";
    }


    /**
     * 上账操作:所有请求参数都必填
     *
     * @param request
     * @param response
     * @param model
     * @param userId      用户ID
     * @param accountCode 账户唯一code值
     * @param type        类型
     * @param serialNum   流水号/承兑协议编号/凭证号
     * @param money       发生金额（元）
     * @param pwd         确认密码
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/user/account/{userId}")
    public String addUserAccountRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                             @PathVariable Long userId, String accountCode, Integer type, String serialNum,
                                             BigDecimal money, String pwd, Long postLine, Integer needCheck, Integer receiveCheck,
                                             String fromParty, String fromBank, String fromAt, String comment) throws Exception {

        upLog.info("============================================================");
        upLog.info(" userId = " + userId + " accountCode = " + accountCode + " type = " + type + "" + " serialNum = " + serialNum
                + " money = " + money + " postLine = " + postLine + " needCheck = " + needCheck + " receiveCheck = " + receiveCheck
                + " fromParty = " + fromParty + " fromBank = " + fromBank + " fromAt = " + fromAt + " comment = " + comment);

        int code = 0;
        try {
            if (DataUtils.isNullOrEmpty(accountCode) || DataUtils.isNullOrEmpty(type) || DataUtils.isNullOrEmpty(serialNum)
                    || DataUtils.isNullOrEmpty(money) || DataUtils.isNullOrEmpty(needCheck) || DataUtils.isNullOrEmpty(fromParty)
                    || DataUtils.isNullOrEmpty(fromBank) || DataUtils.isNullOrEmpty(fromAt)) {
                upLog.info("params is null");
                model.addAttribute("code", -1000);
                return "/data/json";
            }

            if(AccountRecord.TYPE_2.equals(type) && DataUtils.isNullOrEmpty(postLine)){
                model.addAttribute("code", -9002);
                return "/data/json";
            }

            //第一步： 获取登陆账号
            Long mid = getUserId(request);
            upLog.info(" userAccountRelation id =  " + mid);

            //第二步: 获取user_account_relation 记录
            Long id = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(userId, accountCode);

            if (null == id) {
                UserAccountRelation relation = new UserAccountRelation();
                Long accountId = accountService.getObjectByCode(accountCode);
                relation.setAccountId(accountId);
                relation.setAccountCode(accountCode);
                relation.setUserId(userId);
                id = userAccountRelationService.insert(relation);
                upLog.info(userId + " userID and accountCode " + accountCode + " not exist ,so create it ,id is : " + id);
            }else {
                upLog.info(" userAccountRelation id =  " + id);
            }

            UserAccountRelation relation = userAccountRelationService.getObjectById(id);

            User user = userService.getObjectById(userId);

            if(null == user){
                upLog.info(" user : " + userId + " is null");
                model.addAttribute("code", -2000);
                return "common/success";
            }else {
                upLog.info("get user : " + userId + " is not null");
            }

            //第三步： 创建上账记录
            code = userAccountRelationService.addResult(id, money.doubleValue(), serialNum, type, mid, postLine, needCheck, receiveCheck,
                    fromParty, fromBank, fromAt, comment);
        } catch (Throwable t) {
            upLog.error(t.getMessage());
            upLog.error("add userAccountRelation error ");
            code = -1;
        }
        model.addAttribute("code", code);
        return "/data/json";
    }

    /**
     * 实际执行上账
     */
    @RequestMapping(value = "/a/u/user/account/add/{recordId}")
    public String execAddMoney(HttpServletRequest request, ModelMap model, @PathVariable Long recordId, Integer status, String refuseReason) throws Exception {
        int code = 0;
        upExecLog.info("======================================================================");
        upExecLog.info(" EXEC recordId : " + recordId);
        Long userId = getUserId(request);
        User user = new User();
        BigDecimal money = BigDecimal.ZERO;
        AccountRecord accountRecord = accountRecordService.getObjectById(recordId);

        if (null == accountRecord) {
            code = -9103;
        } else {

            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountId(accountRecord.getUserId(), accountRecord.getAccountId());
            upExecLog.info("userAccount id : " + userAccountId);

            UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
            if(null == userAccountRelation){
                code = -2010;
            }else {
                Long uid = userAccountRelation.getUserId();
                if(null == uid){
                    code = -2000;
                }else {
                    user = userService.getObjectById(uid);
                    upExecLog.info("user : " + user);
                }

                money = userAccountRelation.getMoney();
                upExecLog.info("user money : " + money);
            }

            if (AccountRecord.STATUS_2.equals(status)) {
                code = userAccountRelationService.addExec(recordId, userId);

                if(code == 0){
                    //记录流水操作
                    BigDecimal finalMoney = money.add(accountRecord.getAddMoney());
                    upExecLog.info("addExec over , final money is : " + finalMoney);

                    Long id = fundHistoryService.insertTransaction(null, user, FundHistory.TYPE_Charge_Account, FundHistory.DETAIL_Charge, userAccountId,
                            accountRecord.getAddMoney(), null, FundHistory.FLAG_In, FundHistory.STATUS_Pass, null, money, finalMoney);
                    upExecLog.info("insert transaction success : id " + id);
                }

            } else if (status.equals(AccountRecord.STATUS_3)) {
                accountRecord.setStatus(AccountRecord.STATUS_3);
                accountRecord.setRefuseReason(refuseReason);
                accountRecord.setRefuseReason(refuseReason);
                accountRecord.setUpdateBy(userId);
                accountRecord.setUpdateAt(System.currentTimeMillis());
                accountRecordService.update(accountRecord);
            }



        }
        upExecLog.info(" EXEC code : " + code);
        model.addAttribute("id", getUserId(request));
        model.addAttribute("code", code);
        upExecLog.info("==================================  END ====================================");
        return "/data/json";
    }

}

