package com.ptteng.wealth.admin.controller;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.DynamicUtil;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.AutoDocBailClearIn;
import com.ptteng.wealth.consign.model.in.AutoDocBailRechargeIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.AutoDocBailClearOut;
import com.ptteng.wealth.consign.model.out.AutoDocBailRechargeOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.finance.model.*;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.finance.util.PayAccountUtil;
import com.ptteng.wealth.user.model.User;
import com.sun.org.apache.regexp.internal.RE;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.service.RefundsService;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Refunds  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class RefundsController extends BaseController {
    private static final Log log = LogFactory.getLog("refunds");

    @Autowired
    private RefundsService refundsService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private UserAccountRelationService userAccountRelationService;

    @Autowired
    private FundHistoryService fundHistoryService;


    //搜索还款列表
    @RequestMapping(value = "/a/u/refunds/search", method = RequestMethod.GET)
    public String refundSearch(ModelMap model, String name, String mobile, String orderNo, Long startAt, Long endAt, Integer status,
                               @RequestParam(required = false, defaultValue = "1") Integer page,
                               @RequestParam(required = false, defaultValue = "10") Integer size) throws Exception {
        log.info("===========================================================");
        log.info("search refunds data : name: " + name + " mobile: " + mobile + " orderNo: " + orderNo + " status: " + status + " startAt: " + startAt + " endAt: " + endAt);
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        try {
            Map<String, Object> param = new HashMap<>();

            if (null == status) {
                log.info("no status ");
                model.addAttribute("code", -11010);
                return "/common/success";
            }
            if (1 == status) {
                //未退款
                param = DynamicUtil.getNoRefundsListParam(name, mobile, orderNo, startAt, endAt, status, false);
            }

            if (2 == status) {
                //已退款
                param = DynamicUtil.getRefundsListParam(name, mobile, orderNo, startAt, endAt, status, false);
            }

            if (3 == status) {
                //全部
                param = DynamicUtil.getAllRefundsListParam(name, mobile, orderNo, startAt, endAt, false);
            }
            log.info("params : " + param);

            List<Long> ids = refundsService.getIdsByDynamicCondition(Refunds.class, param, start, size);
            List<Refunds> refunds = refundsService.getObjectsByIds(ids);
            log.info("refunds size : " + refunds.size());

            Map<String, Object> cntParam = DynamicUtil.getRefundsListParam(name, mobile, orderNo, startAt, endAt, status, true);
            Long totalSize = refundsService.getIdsByDynamicCondition(Refunds.class, cntParam, 0, 1).get(0);

            for (Refunds refund : refunds) {
                refund.getOrderNo();

            }

            model.addAttribute("total", totalSize);
            Long totalPage = (((totalSize - 1)) / (size)) + 1;
            model.addAttribute("refundsList", refunds);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" search refunds error ");
            model.addAttribute("code", -1);
        }
        return "/wealth-admin-web/refunds/json/refundsListJson";
    }

    //还款详情
    @RequestMapping(value = "/a/u/refund/{id}", method = RequestMethod.GET)
    public String refundDetail(ModelMap model, @PathVariable Long id) throws Exception {
        log.info("===========================================================");
        log.info("get refund data : " + id);

        try {
            Refunds refunds = refundsService.getObjectById(id);

            model.addAttribute("code", 0);
            model.addAttribute("refunds", refunds);

            if(null != refunds){
                Long verifyId = refunds.getVerifyBy();
                if(null != verifyId){
                    Manager manager = managerService.getObjectById(verifyId);
                    if(null != manager){
                        model.addAttribute("verifyName", manager.getNick());
                    }else {
                        log.info("manager : " + verifyId + " not exist");
                    }
                }else {
                    log.info("refund : " + id + " no verify manager");
                }
            }else {
                log.info("refunds " + id + " not exist");
            }

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            t.printStackTrace(System.err);
            log.error(t.getMessage());
            log.error(" get refunds error ");
            model.addAttribute("code", -1);
        }
        return "/wealth-admin-web/refunds/json/refundsDetailJson";
    }

    //还款审核
    @RequestMapping(value = "/a/u/refunds/{id}/verify/{level}", method = RequestMethod.POST)
    public String verifyDebt(HttpServletRequest request, ModelMap model, @PathVariable Long id, @PathVariable Long level, String comment) throws Exception {// 这里的name是单元name
        log.info("verify refund id : " + id + " comment " + comment + " level " + level);
        Long mid = getUserId(request);
        try {

            // 判断还款在不在
            Refunds refunds = this.refundsService.getObjectById(id);
            if (refunds == null) {
                model.addAttribute("code", -13000);
                return "/common/success";
            }

            //判断还款申请是不是还是审核中
            if (!Refunds.Status_Verifying.equals(refunds.getStatus())) {
                model.addAttribute("code", -13005);
                return "/common/success";
            }

            if (2 == level) {
                // 驳回
                log.info("refuse refunds ");
                refunds.setStatus(Refunds.Status_refuse);
                refunds.setVerifyAt(System.currentTimeMillis());
                refunds.setVerifyBy(mid);
                refunds.setReason(comment);
                refundsService.update(refunds);
                log.info("refuse refunds " + id + " success ");

            } else if (1 == level) {
                log.info(" pass the verify ");

                // 审核通过，获取退款对应订单号
                Long oid = orderService.getOrderIdByOrderNo(refunds.getOrderNo());
                log.info(" oid : " + oid);
                if (null == oid) {
                    model.addAttribute("code", -13000);
                    return "/common/success";
                }

                Order order = orderService.getObjectById(oid);
                Long uid = order.getUid();
                log.info(" uid : " + uid);

                if (null == uid) {
                    log.info("error order");
                    model.addAttribute("code", -4006);
                    return "/common/success";
                }
                if (!uid.equals(refunds.getUid())) {
                    log.info("error order");
                    model.addAttribute("code", -4007);
                    return "/common/success";
                }

                User user = userService.getObjectById(uid);

                //根据订单支付方式判断将钱退到哪个账户
                Integer payType = order.getPayType();
                log.info("order payType : " + payType);

                if (Order.Pay_Type_fund.equals(payType)) {
                    //证联支付
                    log.info("refund to daixiao");

                    String autotransNo = "";
                    AutoDocBailRechargeOut autoDocBailRechargeOut = null;
                    AutoDocBailClearOut docBailClearOut = null;
                    BindingBank bindingBank = null;
                    try {
                        //一.  机构用户处理逻辑
                        BindingBankIn bindingBankIn = new BindingBankIn();
                        bindingBankIn.setUserId(user.getId() + "");
                        bindingBankIn.setFundAccount(user.getFundAccount());
                        bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
                        List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
                        for (BindingBank bank : bindingBanks) {
                            if (bank.getBankNo().equals("ZLRT")) {
                                bindingBank = bank;
                                break;
                            }
                        }
                        log.info(" BANK:  " + bindingBank);

                        String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
                        //非常关键，获取要支付的开磷账号
                        Long accountId = accountService.getObjectByCode(accountCode);
                        Account account = accountService.getObjectById(accountId);

                        if(null == account){
                            log.info("account not exist");
                            model.addAttribute("code", -13006);
                        }
                        String accountName = account.getName();
                        log.info("accountId : " + accountName);

                        String companyAccount = constantService.getValue(accountName+"account" ,"fundAccount" );
                        log.info(accountName + " account : " + companyAccount);

                        String companyPwd = constantService.getValue(accountName+"pwd" ,"fundAccount" );
                        log.info(accountName + " pwd : " + companyPwd);

                        AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
                        organBindCardIn.setUserId(user.getId() + "");
                        organBindCardIn.setPassword(companyPwd);
                        organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
                        organBindCardIn.setFundAccountG(Integer.valueOf(companyAccount));
                        organBindCardIn.setFundAccountB(user.getFundAccount());
                        organBindCardIn.setOpbusinessFlag("8035");
                        organBindCardIn.setOccurBalanceG(refunds.getRefundTot());
                        organBindCardIn.setTiedCardType("0");
                        organBindCardIn.setMoneyType("0");
                        organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
                        organBindCardIn.setFundCode(990006 + "");
                        organBindCardIn.setPayType("0");
                        organBindCardIn.setChannelResource("");
                        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        organBindCardIn.setBankNoDk("ZLRT");
                        organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
                        organBindCardIn.setAutotransNo("");
                        log.info("organBindCardIn : " + organBindCardIn);
                        autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
                    } catch (Exception e) {
                        e.printStackTrace(System.out);
                        log.error(e.getMessage());
                    }
                    log.info(autoDocBailRechargeOut);
                    model.put("code", autoDocBailRechargeOut.getErrorNo());
                    model.put("message", autoDocBailRechargeOut.getErrorInfo());
                    log.info("error code is " + autoDocBailRechargeOut.getErrorNo());
                    log.info("error info is " + autoDocBailRechargeOut.getErrorInfo());
                    if (0 == autoDocBailRechargeOut.getErrorNo()) {
                        autotransNo = autoDocBailRechargeOut.getAutotransNo();
                        log.info("autotransNo is " + autotransNo);
                    } else {
                        log.info("consign 9751 fail");
                        return "/common/success";
                    }

                    try {
                        AutoDocBailClearIn docBailClearIn = new AutoDocBailClearIn();
                        docBailClearIn.setUserId(user.getId() + "");
                        docBailClearIn.setBranchNo(GlobalConstant.BRANCH_NO);
                        docBailClearIn.setFundAccountG(GlobalConstant.KAILIN_ACCOUNT_A);
                        docBailClearIn.setFundAccountB(user.getFundAccount());
                        docBailClearIn.setFundAccountC(GlobalConstant.KAILIN_ACCOUNT_A);
                        docBailClearIn.setOccurBalanceG(new BigDecimal("0"));
                        docBailClearIn.setOccurBalanceB(refunds.getRefundTot());
                        docBailClearIn.setOccurBalanceC(new BigDecimal("0"));
                        docBailClearIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        docBailClearIn.setAutotransNo(autotransNo);
                        log.info("docBailClearIn : " + docBailClearIn);
                        docBailClearOut = consignmentService.autoDocBailClear(docBailClearIn);

                    } catch (Exception e) {
                        e.printStackTrace(System.out);
                        log.error(e.getMessage());
                    }
                    log.info(docBailClearOut);
                    model.put("code", docBailClearOut.getErrorNo());
                    model.put("message", docBailClearOut.getErrorInfo());
                    log.info("error code is " + docBailClearOut.getErrorNo());
                    log.info("error info is " + docBailClearOut.getErrorInfo());
                    if (0 == docBailClearOut.getErrorNo()) {
                        log.info("refund to daixiao success");
                    } else {
                        log.info("DAI XIAO fail");
                        return "/common/success";
                    }

                    refunds.setStatus(Refunds.Status_pass);
                    refunds.setVerifyAt(System.currentTimeMillis());
                    refunds.setRefundAt(System.currentTimeMillis());
                    refunds.setVerifyBy(mid);
                    refundsService.update(refunds);
                    log.info("update refunds " + id + " success ");

                    return "/common/success";


                } else if (Order.Pay_Type_post.equals(payType) || Order.Pay_Type_check.equals(payType) || Order.Pay_Type_klfund.equals(payType)) {
                    log.info("refund to kailin");
                    refunds(order, uid, refunds.getRefundTot());

                } else if (Order.Pay_Type_Loan.equals(payType)) {
                    log.info("loan order");
                    //获取订单对应借款申请
                    Long loanApplyId = loanApplyService.getLoanApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getOrderNo());
                    log.info("loanApplyId : " + loanApplyId);
                    if (null == loanApplyId) {
                        model.addAttribute("code", -11003);
                        return "/common/success";
                    }
                    LoanApply loanApply = loanApplyService.getObjectById(loanApplyId);
                    if (null == loanApply) {
                        model.addAttribute("code", -11003);
                        return "/common/success";
                    }

                    //是否还清
                    BigDecimal refundMoney = new BigDecimal("0");
                    if (LoanApply.TYPE_CLEAR.equals(loanApply.getType())) {
                        log.info("clear loan apply");
                        refundMoney = caculate(loanApply.getDebtCount(), loanApply.getRepayTot(), refunds.getRefundTot());
                        refunds(order, uid, refundMoney);
                    } else if (LoanApply.TYPE_OVERTIME.equals(loanApply.getType()) || LoanApply.TYPE_REPAY.equals(loanApply.getType())) {
                        log.info("not clear loan apply");
                        BigDecimal debtCount = loanApply.getDebtCount();
                        loanApply.setDebtCount(debtCount.subtract(refunds.getRefundTot()));
                        loanApplyService.update(loanApply);
                    }
                } else if (Order.Pay_Type_Small.equals(payType)) {
                    log.info("small loan order");
                    //获取订单对应借款申请
                    Long loanApplyId = loanApplyService.getLoanApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getOrderNo());
                    log.info("loanApplyId : " + loanApplyId);
                    if (null == loanApplyId) {
                        model.addAttribute("code", -11003);
                        return "/common/success";
                    }

                    LoanApply loanApply = loanApplyService.getObjectById(loanApplyId);
                    if (null == loanApply) {
                        model.addAttribute("code", -11003);
                        return "/common/success";
                    }

                    //是否还清
                    if (LoanApply.TYPE_CLEAR.equals(loanApply.getType())) {
                        log.info("clear loan apply");
                        refunds(order, uid, refunds.getRefundTot());
                    } else if (LoanApply.TYPE_OVERTIME.equals(loanApply.getType()) || LoanApply.TYPE_REPAY.equals(loanApply.getType())) {
                        BigDecimal debtCount = loanApply.getDebtCount();
                        loanApply.setDebtCount(debtCount.subtract(refunds.getRefundTot()));
                        loanApplyService.update(loanApply);

                        Fund fund = fundService.getObjectById(uid);
                        Long smallLoanAt = loanApply.getCreateAt();
                        increaseSmallLine(fund, refunds.getRefundTot(), smallLoanAt);
                    }
                } else if (Order.Pay_Type_Debt.equals(payType)) {
                    //获取订单对应借款申请
                    Long debtApplyId = debtApplyService.getDebtApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getOrderNo());
                    log.info("debtApplyId : " + debtApplyId);
                    if (null == debtApplyId) {
                        model.addAttribute("code", -11003);
                        return "/common/success";
                    }

                    DebtApply debtApply = debtApplyService.getObjectById(debtApplyId);
                    if (null == debtApply) {
                        model.addAttribute("code", -11003);
                        return "/common/success";
                    }

                    //是否还清
                    BigDecimal refundMoney = new BigDecimal("0");
                    if (DebtApply.TYPE_CLEAR.equals(debtApply.getType())) {
                        refundMoney = caculate(debtApply.getDebtCount(), debtApply.getRepayTot(), refunds.getRefundTot());
                        refunds(order, uid, refundMoney);
                    } else if (LoanApply.TYPE_OVERTIME.equals(debtApply.getType()) || LoanApply.TYPE_REPAY.equals(debtApply.getType())) {
                        BigDecimal debtCount = debtApply.getDebtCount();
                        debtApply.setDebtCount(debtCount.subtract(refunds.getRefundTot()));
                        debtApplyService.update(debtApply);

                        Fund fund = fundService.getObjectById(uid);
                        BigDecimal loanTot = fund.getLoanTot();
                        BigDecimal loanNowTot = fund.getLoanNowTot();
                        fund.setLoanTot(loanTot.subtract(refunds.getRefundTot()));
                        fund.setLoanNowTot(loanNowTot.subtract(refunds.getRefundTot()));
                        fundService.update(fund);
                    }
                }
                log.info("pass refunds " + id + " success ");

                refunds.setStatus(Refunds.Status_pass);
                refunds.setVerifyAt(System.currentTimeMillis());
                refunds.setRefundAt(System.currentTimeMillis());
                refunds.setVerifyBy(mid);
                refundsService.update(refunds);
                log.info("update refunds " + id + " success ");

            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" search  user error ");
            model.addAttribute("code", -1);
        }
        model.addAttribute("code", 0);
        return "/common/success";

    }

    //计算还款金额
    public BigDecimal caculate(BigDecimal debtCount, BigDecimal repayTot, BigDecimal refundTot) {
        log.info("caculate refund money : debtCount = " + debtCount + " repayTot = " + repayTot + " refundTot = " + refundTot);
        BigDecimal result = repayTot.multiply(refundTot).divide(debtCount, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }

    //退款
    public void refunds(Order order, Long uid, BigDecimal refunds) throws Exception {

        User user = userService.getObjectById(uid);

        log.info("refund money to kailin account ");
        String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
        //非常关键，获取要支付的开磷账号
        Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
        log.info("userAccountId : " + userAccountId);

        UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
        BigDecimal money = userAccountRelation.getMoney();
        log.info("account money : " + userAccountRelation.getMoney());

        userAccountRelation.setMoney(money.add(refunds));
        log.info("refund to user " + uid + " account " + accountCode + " : " + userAccountId + " , " + money + " >>>>>>>>>> " + userAccountRelation.getMoney());

        //记录流水操作
        Long id = fundHistoryService.insertTransaction(order, user, FundHistory.TYPE_Refund, FundHistory.DETAIL_Refund, userAccountId,
                order.getPriceTot() , null, FundHistory.FLAG_In, FundHistory.STATUS_Pass, null, money, userAccountRelation.getMoney());
        log.info("insert transaction success : id " + id);

        userAccountRelationService.update(userAccountRelation);
    }

    //退款增加用户小额限额与日限额
    public Boolean increaseSmallLine(Fund fund, BigDecimal refundTot, Long smallLoanAt) throws Exception {
        log.info("increase user : " + fund.getId() + " small line " + refundTot);
        BigDecimal smallLoanTot = fund.getSmallLoanTot();
        BigDecimal todaySamllLoan = fund.getTodaySmallLoan();

        //该退款小额时间日期结束时间
        log.info("loan at : " + smallLoanAt);
        Long time = MyTimeUtil.getEndTime(smallLoanAt);

        //判断是否需要减少当日小额借贷金额
        if (System.currentTimeMillis() < time) {
            fund.setTodaySmallLoan(todaySamllLoan.subtract(refundTot));
        }else {
            log.info("small loan more than one day to now ");
        }

        fund.setSmallLoanTot(smallLoanTot.subtract(smallLoanTot));

        Boolean result = fundService.update(fund);
        return result;
    }
}

