package com.ptteng.wealth.admin.controller;

import com.ptteng.wealth.user.model.OrgApplyRecord;
import com.ptteng.wealth.user.service.OrgApplyRecordService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * OrgApplyRecord  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class OrgApplyRecordController {
	private static final Log log = LogFactory.getLog(OrgApplyRecordController.class);

	@Autowired
	private OrgApplyRecordService orgApplyRecordService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/web/c/orgApplyRecord", method = RequestMethod.GET)
	public String getorgApplyRecordList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/orgApplyRecord  to /orgApplyRecord/view/orgApplyRecordList");

		return "/wealth-user-service/orgApplyRecord/view/orgApplyRecordList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/web/c/orgApplyRecord1 ", method = RequestMethod.GET)
	public String getOrgApplyRecordIdsByOrgApplyIdList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long orgApplyId) throws Exception {

		log.info("/web/orgApplyRecord  to /orgApplyRecord/view/orgApplyRecordList");

		return "/wealth-user-service/orgApplyRecord/view/orgApplyRecordList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/web/c/orgApplyRecord/{id}", method = RequestMethod.GET)
	public String getOrgApplyRecord(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/orgApplyRecord/" + id + "  to /orgApplyRecord/view/orgApplyRecordDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/wealth-user-service/orgApplyRecord/view/orgApplyRecordDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/web/a/orgApplyRecord1 ", method = RequestMethod.GET)
	public String getOrgApplyRecordIdsByOrgApplyIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long orgApplyId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= orgApplyRecordService.getOrgApplyRecordIdsByOrgApplyId(orgApplyId,start,size);
		log.info("get countOrgApplyRecordIdsByOrgApplyId size is " + ids.size());

			List<OrgApplyRecord> orgApplyRecordList = orgApplyRecordService.getObjectsByIds(ids);
			log.info("get orgApplyRecord data is " + orgApplyRecordList.size());

			Integer total = orgApplyRecordService. countOrgApplyRecordIdsByOrgApplyId(orgApplyId);
			log.info("get orgApplyRecord count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("orgApplyRecordList", orgApplyRecordList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get orgApplyRecord list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/wealth-user-service/orgApplyRecord/json/orgApplyRecordListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/web/a/orgApplyRecord/{id}", method = RequestMethod.GET)
	public String getOrgApplyRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			OrgApplyRecord orgApplyRecord = orgApplyRecordService.getObjectById(id);
			log.info("get orgApplyRecord data is " + orgApplyRecord);

			model.addAttribute("code", 0);

			model.addAttribute("orgApplyRecord", orgApplyRecord);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get orgApplyRecord error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/wealth-user-service/orgApplyRecord/json/orgApplyRecordDetailJson";
	}

	@RequestMapping(value = "/web/a/orgApplyRecord/{id}", method = RequestMethod.PUT)
	public String updateOrgApplyRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, OrgApplyRecord orgApplyRecord) throws Exception {
		
		log.info("update orgApplyRecord : orgApplyRecord= " + orgApplyRecord);
		
		try {
			
			orgApplyRecordService.update(orgApplyRecord);

			model.addAttribute("code", 0);

			model.addAttribute("orgApplyRecord", orgApplyRecord);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update orgApplyRecord error,id is  " + orgApplyRecord.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/orgApplyRecord", method = RequestMethod.POST)
	public String addOrgApplyRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, OrgApplyRecord orgApplyRecord) throws Exception {
		
		log.info("update orgApplyRecord : orgApplyRecord= " + orgApplyRecord);
		
		try { 
			orgApplyRecord.setId(null);

			orgApplyRecordService.insert(orgApplyRecord);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add orgApplyRecord error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/orgApplyRecord/{id}", method = RequestMethod.DELETE)
	public String deleteOrgApplyRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete orgApplyRecord : id= " + id);
		try {
			orgApplyRecordService.delete(id);

			log.info("add orgApplyRecord success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete orgApplyRecord error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/orgApplyRecord", method = RequestMethod.GET)
	public String getMultiOrgApplyRecordJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<OrgApplyRecord> orgApplyRecordList = orgApplyRecordService.getObjectsByIds(idList);
			log.info("get  orgApplyRecord data is " + orgApplyRecordList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",orgApplyRecordList.size());

			model.addAttribute("orgApplyRecordList", orgApplyRecordList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get orgApplyRecord error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/wealth-user-service/orgApplyRecord/json/orgApplyRecordListJson";
	}
	
	
}

