package com.ptteng.wealth.admin.interceptor;

import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.model.Module;
import com.ptteng.wealth.admin.model.Records;
import com.ptteng.wealth.admin.model.RoleModule;
import com.ptteng.wealth.admin.service.*;
import com.ptteng.wealth.admin.util.CookieUtil;
import com.qding.common.util.http.cookie.RequestUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;

public class UserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(UserInterceptor.class);
    private static final Log intercepterLog = LogFactory.getLog("intercepterLog");

    @Autowired
    private ManagerService managerService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private RecordsService recordsService;
    @Autowired
    private RoleModuleService roleModuleService;
    public static String SPLITTER_REGEX = "\\|";
    public static final String USER_ID = "userId";
    @Autowired
    private CookieUtil cookieUtil;


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        intercepterLog.info("intercepter preHandle start ...");

        String token = request.getParameter("token");
        if (null == token) {
            token = request.getHeader("token");
        }
        Long uid = 0l;
        try {
            uid = cookieUtil.getID(request);
            intercepterLog.info("Uid" + uid);
            if (uid == null) {
                log.error("not legal user request");
                return noLogin(request, response);
            }

        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        intercepterLog.info("get uid  from cookie is " + uid);
        Manager manager = this.managerService.getObjectById(uid);
        if (manager == null) {
            log.error(uid + " not get any data ");
            return noLogin(request, response);
        } else {
            request.setAttribute("manager", manager);
        }
        String requestUrl = this.getInterceptorUrl(request);
        intercepterLog.info(" requstUrl  " + requestUrl);

        List<Long> roleModuleIds = roleModuleService.getRoleModuleIdsByRid(manager.getRoleID(), 0, Integer.MAX_VALUE);
        List<RoleModule> roleModules = roleModuleService.getObjectsByIds(roleModuleIds);
        List<Long> mids = new ArrayList<Long>();
        for (RoleModule roleModule : roleModules) {
            mids.add(roleModule.getMid());
        }
        intercepterLog.info("role modules is : " + mids);
        List<Module> modules = moduleService.getObjectsByIds(mids);
        boolean flag = false;
        String[] requestUrls = requestUrl.split("\\?");
        intercepterLog.info(" reqeust is " + requestUrls[0]);
        for (Module module : modules) {
            intercepterLog.info(" module " + module.getId() + " url is  " + module.getUrl());
            String[] moduleUrls = module.getUrl().split("\\.");
            intercepterLog.info(" managerUrl  is  " + moduleUrls.length);
            if (moduleUrls.length > 1) {
                if (requestUrls[0].contains(moduleUrls[1]))
                    intercepterLog.info(uid + " is have module " + moduleUrls[1]);
                flag = true;
                break;
            }
        }
//        if(flag==false){
//            log.info(uid +" is don't have module "+requestUrl);
//            return  noPermission(response);
//        }
        intercepterLog.info("flag is " + flag);
        return true;
    }


    private boolean noPermission(HttpServletResponse response) throws IOException {
        response.sendRedirect("/a/noPermissin");
        return false;

    }

    private boolean noLogin(HttpServletRequest request,HttpServletResponse response) throws Exception {
        request.getRequestDispatcher("/a/nologin").forward(request,response);
        return false;

    }

    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

        log.info("p =========================================== ");
        Cookie[] cookies =request.getCookies();
        for(Cookie cookie : cookies){
            cookie.setMaxAge(cookieUtil.getMaxAge());
            cookie.setDomain(cookieUtil.getDomain());
            cookie.setPath("/");
            response.addCookie(cookie);

        }

//        log.info("add module record begin ====");
//        Long uid =  cookieUtil.getID(request);
//        Manager manager = this.managerService.getObjectById(uid);
//
//        String targetId = request.getParameter("targetId");
//
//        String requestUrl = this.getInterceptorUrl(request);
//        log.info(" requstUrl  " + requestUrl);
//
//        String moduleRecord = "";
//        Pattern p = Pattern.compile("((/a)?)((/u)?)((/multi)?)(/(.*?))((/.*)?)(\\?.*?)");
//        Matcher m = p.matcher(requestUrl);
//        while(m.find()){
//            moduleRecord = m.group(8);
//        }
//
//        Long moduleId = moduleService.getModuleIdByUrlAndType("field."+moduleRecord,"web");
//
//        Records records = new Records();
//        records.setManagerID(uid);
//        records.setModuleID(moduleId);
//        records.setOperate(request.getMethod());
//        records.setTargetID(Long.valueOf(targetId));
//        records.setRoleID(manager.getRoleId());
//        records.setOperateAt(System.currentTimeMillis());
//        recordsService.insert(records);


    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI()
                + (null == request.getQueryString() ? "" : "?"
                + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");

        log.info("get getInterceptorUrl is " + interceptorUrl);

        return interceptorUrl;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {

//        String x = URLEncoder.encode("p/hello", "utf-8");
//        log.info(x);
        String requestUrl = "/a/u/multi/role/ii/iii?ids=170&ids=172&ids=172&ids=172";
        Pattern p = Pattern.compile("((/a)?)((/u)?)((/multi)?)(/(.*?))((/.*)?)(\\?.*?)");
        Matcher m = p.matcher(requestUrl);
        while (m.find()) {
            System.out.println(m.group(0));
            System.out.println(m.group(8));
        }
    }
}
