package com.ptteng.wealth.admin.controller;


import com.ptteng.wealth.admin.Environment;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.util.CookieUtil;
import com.ptteng.wealth.admin.util.EmptySerializer;
import com.ptteng.wealth.admin.util.ErrCode;
import com.ptteng.wealth.admin.util.ResultPropertyes;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.service.*;
import com.ptteng.wealth.finance.service.account.AccountRecordService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.ser.StdSerializerProvider;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.*;

/**
 * Created by arthur on 16/7/20.
 */
public class BaseController {
    public static final String WriterKey = "writer";
    public static final String UserKey = "user";
    private static final byte[] x = new byte[]{0x01};
    public static final String SPLITER_X = new String(x);
    public static Long adminUserId = null;
    private static ThreadLocal<ObjectMapper> templateThreadLocal = new ThreadLocal<ObjectMapper>();
    public static final String Img_Module_Common = "common";
    public static String SPLITTER_REGEX = "\\|";
    public static final String USER_ID = "userId";

    @Autowired
    public ManagerService managerService;
    @Autowired
    public UserService userService;
    @Autowired
    public ConsignmentService consignmentService;
    @Autowired
    public FundService fundService;
    @Autowired
    public CookieUtil cookieUtil;
    @Autowired
    public PersonService personService;
    @Autowired
    public Environment environment;
    @Autowired
    public UserOpenidRelationService userOpenidRelationService;
    @Autowired
    public AccountRecordService accountRecordService;
    @Autowired
    public AccountService accountService;
    @Autowired
    public OrderService orderService;
    @Autowired
    public DebtApplyService debtApplyService;
    @Autowired
    public ConstantService constantService;
    @Autowired
    public CreditApplyService creditApplyService;
    @Autowired
    public OrganizationService organizationService;
    @Autowired
    public LoanApplyService loanApplyService;

    @Autowired
    public LoanProductService loanProductService;


    protected Log log = LogFactory.getLog(this.getClass());

    public static ObjectMapper getJsonCallBackTemplate() {
        if (templateThreadLocal.get() == null) {
            ObjectMapper objmap = new ObjectMapper();
            // First: need a custom serializer provider
            StdSerializerProvider sp = new StdSerializerProvider();
            sp.setNullValueSerializer(new EmptySerializer());
            objmap.setSerializerProvider(sp);
            templateThreadLocal.set(objmap);
            return objmap;
        } else {
            return templateThreadLocal.get();
        }
    }

    public Map<String, Object> checkAndGetWriter(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> infoMap = null;
        PrintWriter writer = null;
        HashMap<String, String> errorMap = new HashMap<String, String>();
        try {
            writer = response.getWriter();
        } catch (IOException e) {
            e.printStackTrace(System.out);  //To change body of catch statement use File | Settings | File Templates.
        }
        if (null == writer) {
            errorMap.put(ResultPropertyes.ERROR_CODE, ErrCode.ERROR_NULL_RESULT);
            errorMap.put(ResultPropertyes.ERROR_INFO, ErrCode.ERROR_NULL_RESULT_INFO);
            writeConent(writer, response, false, 500, null, null, null, errorMap);
            return null;
        }
        infoMap = new HashMap<String, Object>();
        infoMap.put(WriterKey, writer);
        return infoMap;
    }

    public String handleResult(Boolean bSucess, int statusCode, PrintWriter writer, HttpServletResponse httpServletResponse) {
        return handleResult(writer, httpServletResponse, bSucess, statusCode, null, null, null);
    }

    public String handleResult(PrintWriter writer, HttpServletResponse httpServletResponse, boolean bSuccess, int statusCode, Map<String, String> stringInfoMap, Map<String, Long> numberInfoMap, Map<String, Object> objInfoMap) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (!bSuccess) {
            errorMap.put(ResultPropertyes.ERROR_CODE, ErrCode.ERROR_BY_DB);
            errorMap.put(ResultPropertyes.ERROR_INFO, ErrCode.ERROR_BY_DB_INFO);
        }
        return writeConent(writer, httpServletResponse, bSuccess, statusCode, stringInfoMap, numberInfoMap, objInfoMap, errorMap);
    }

    public String writeConent(PrintWriter writer, HttpServletResponse httpServletResponse, boolean bSuccess, int statusCode, Map<String, String> stringInfoMap, Map<String, Long> numberInfoMap, Map<String, Object> objInfoMap, Map<String, String> errorMap) {
        JsonGenerator generator = null;
        try {
            httpServletResponse.setStatus(statusCode);
            httpServletResponse.setContentType("text/html;charset=utf-8");
            JsonFactory factory = new JsonFactory();
            generator = factory.createJsonGenerator(writer);
            ObjectMapper objmap = getJsonCallBackTemplate(); //get from localthread
            SerializationConfig serializationConfig = objmap.getSerializationConfig();
            generator.setCodec(objmap);
            generator.writeStartObject();

            if (bSuccess) {
                switch (statusCode) {
                    case HttpServletResponse.SC_NO_CONTENT:
                        break;
                    case HttpServletResponse.SC_CREATED:
                    case HttpServletResponse.SC_OK:
                        if (null != stringInfoMap) {
                            Iterator<String> strIter = stringInfoMap.keySet().iterator();
                            while (strIter.hasNext()) {
                                String key = strIter.next();
                                generator.writeStringField(key, ObjectUtils.toString(stringInfoMap.get(key), ""));
                            }
                        }
                        if (null != numberInfoMap) {
                            Iterator<String> numIter = numberInfoMap.keySet().iterator();
                            while (numIter.hasNext()) {
                                String key = numIter.next();
                                generator.writeNumberField(key, numberInfoMap.get(key));
                            }
                        }
                        if (null != objInfoMap) {
                            Iterator<String> objIter = objInfoMap.keySet().iterator();
                            while (objIter.hasNext()) {
                                String key = objIter.next();
                                generator.writeObjectField(key, objInfoMap.get(key));
                            }
                        }
                        break;
                }
            } else {
                generator.writeStringField(ResultPropertyes.ERROR_CODE, (String) errorMap.get(ResultPropertyes.ERROR_CODE));
                generator.writeStringField(ResultPropertyes.ERROR_INFO, (String) errorMap.get(ResultPropertyes.ERROR_INFO));
            }

            generator.writeEndObject();
            generator.close();
        } catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public Long getUserId(HttpServletRequest request) {
        Long uid = cookieUtil.getID(request);
        return uid;
    }

    public String getErrorCode(Long errorId) {
        String errorCode = "";
        return errorCode;
    }

    public String getErrorInfo(Long errorId) {
        String errorCode = "";
        return errorCode;
    }

    public Integer totalPage(Integer size, Integer totalSize) {
        if (0 == totalSize) {
            return 0;
        } else {
            return (((totalSize - 1)) / (size)) + 1;
        }
    }

}
