package com.ptteng.wealth.admin.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.util.TokenUtils;
import com.ptteng.wealth.admin.controller.BaseController;
import com.ptteng.wealth.admin.util.CookieUtil;
import com.ptteng.wealth.user.model.User;
import com.qding.common.util.http.cookie.RequestUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.admin.interceptor.CookieConstant;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.model.Role;
import com.ptteng.wealth.admin.service.ManagerService;
import com.ptteng.wealth.admin.service.RoleService;
import com.qding.common.util.json.GsonUtil;
import com.gemantic.common.util.PasswordUtils;


@Controller
public class SystemController extends BaseController {
    private static final Log log = LogFactory.getLog(SystemController.class);

    private static final Log loginLog = LogFactory.getLog("login");

    private static final Log logoutLog = LogFactory.getLog("logout");
    @Autowired
    private ManagerService managerService;

    @Autowired
    private RoleService roleService;

    @Autowired
    private String casServerLogoutUrl;

    @Autowired
    private String  localUrl;

    @Autowired
    private String casServerLogintUrl;


    @RequestMapping(value = "/a/nologin")
    public String noLogin(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, Integer page,
                          Integer size) throws Exception {
        log.info(" login wrong ");
        model.addAttribute("code", -2);
        return "/data/json";
    }

    @RequestMapping(value = "/a/noPermissin")
    public String noPermission(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Integer page,
                               Integer size) throws Exception {
        log.info(" login noPermission ");
        model.addAttribute("code", -5020);
        return "/data/json";
    }

    @RequestMapping(value = "/a/testabc")
    public String test(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model, Integer page,
                       Integer size) throws Exception {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        Cookie c = RequestUtil.getCookie(request, cookieUtil.getLoginName());
        objMap.put("cookie", c);
        writeConent(response.getWriter(), response, true, 200, null, null, objMap, null);
        return null;
    }

//	@RequestMapping(value = "/web/a/publics/del/{id}", method = RequestMethod.DELETE)
//	public String delete(HttpServletRequest request,
//			HttpServletResponse response, ModelMap model, @PathVariable long id) {
//		log.info(" welcome to publics delete ");
//		if (id == 0) {
//			model.addAttribute("success", false);
//			model.addAttribute("message", "未选择公众号");
//			model.addAttribute("result", null);
//			return "/data/json";
//		}
//		try {
//			boolean success = this.publicsService.delete(id);
//			if (success) {
//				model.addAttribute("success", true);
//				model.addAttribute("message", "删除成功");
//				model.addAttribute("result", null);
//			} else {
//				model.addAttribute("success", false);
//				model.addAttribute("message", "删除失败");
//				model.addAttribute("result", null);
//			}
//		} catch (Throwable t) {
//			log.error(t.getMessage());
//			log.error("delete publics list error,id is  " + id);
//			model.addAttribute("success", false);
//			model.addAttribute("message", "删除失败");
//			model.addAttribute("result", null);
//		}
//
//		return "/data/json";
//	}
//

//    /**
//     * 管理员登录
//     *
//     * @param request
//     * @param response
//     * @param model
//     * @param name
//     * @param pwd
//     * @return
//     */
//    @RequestMapping(value = "/a/login", method = RequestMethod.POST)
//    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name, String pwd) {
//        loginLog.info(" welcome to manager login ");
//
//        try {
//            Long id = getUserId(request);
//            List<Long> managerIds = this.managerService.getManagerIdsByName(name, 0, Integer.MAX_VALUE);
//            loginLog.info(name + " get managerIDs  " + managerIds);
//            if (managerIds == null || managerIds.isEmpty() || managerIds.size() > 1) {
//                log.info(name + " not get any user ");
//                model.addAttribute("code", -2000);
//            } else {
//                loginLog.info(name + "  get user " + managerIds.get(0));
//                Manager manager = this.managerService.getObjectById(managerIds.get(0));
//                if (PasswordUtils.authenticatePassword(manager.getPwd(), pwd) && manager.getStatus().equals(Manager.STATUS_USING)) {
//                    loginLog.info(managerIds.get(0) + " login success");
//                    String token = TokenUtils.createToken(manager.getId());
//                    loginLog.info("maxAge :" + cookieUtil.getMaxAge());
//                    RequestUtil.setCookie(response,cookieUtil.getLoginName(),token,cookieUtil.getMaxAge(),cookieUtil.getDomain(),"/");
//                    Role role = roleService.getObjectById(manager.getRoleID());
//                    if (role == null) {
//                        loginLog.error("not get any role  " + manager.getRoleID());
//                        model.addAttribute("code", -2012);
//                        return "/data/json";
//                    }
//                    model.addAttribute("code", 0);
//                    model.addAttribute("manager", manager);
//                    model.addAttribute("role", role);
//                    loginLog.info(managerIds.get(0) + " login over ");
//                } else {
//                    loginLog.info(managerIds.get(0) + " has wrong pwd ");
//                    model.addAttribute("code", -2013);
//                    model.addAttribute("result", null);
//                }
//            }
//        } catch (Throwable t) {
//            loginLog.error(t.getMessage());
//            loginLog.error("manager login error,name is  " + name);
//            model.addAttribute("code", -5002);
//            model.addAttribute("result", null);
//        }
//
//        return "/data/login";
//    }


    /**
     * 管理员登录
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/login")
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        loginLog.info(" welcome to manager login ");

        try {
            Long id = getUserId(request);
            Manager manager = managerService.getObjectById(id);
            Role role = roleService.getObjectById(manager.getRoleID());
            if (role == null) {
                loginLog.error("not get any role  " + manager.getRoleID());
                model.addAttribute("code", -2012);
                return "/data/json";
            }
            model.addAttribute("code", 0);
            model.addAttribute("manager", manager);
            model.addAttribute("role", role);
        } catch (Throwable t) {
            loginLog.error(t.getMessage());
            model.addAttribute("code", -5002);
            model.addAttribute("result", null);
        }

        return "/data/login";
    }

    /**
     * 退出系统
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/logout")
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        logoutLog.info("casServerLogoutUrl: "+casServerLogoutUrl);
        logoutLog.info("localUrl: "+localUrl);
        Cookie[] cookies = request.getCookies();
        for (Cookie cookie : cookies) {
            cookie.setMaxAge(0);
            cookie.setValue("");
            cookie.setPath("/");
            cookie.setDomain(cookieUtil.getDomain());
            response.addCookie(cookie);

        }

//            request.getSession().invalidate();
//            return "redirect:"+casServerLogoutUrl+"?service="+localUrl;
           return "logout";

    }

    /**
     * 返回登陆用户信息
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/u/manager", method = RequestMethod.GET)
    public String getUser(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager getmanager ");

        try {
            if (null != getUserId(request)) {

                String userName = cookieUtil.getKeyIdentity(request, CookieConstant.Cookie_WEB_ManagerName);
                String publicsHash = cookieUtil.getKeyIdentity(request, CookieConstant.Cookie_WEB_ManagerPublicsHash);

                Map<String, String> maps = new HashMap();
                maps.put(CookieConstant.Cookie_WEB_ManagerName, userName);
                maps.put(CookieConstant.Cookie_WEB_ManagerPublicsHash, publicsHash);
                maps.put(CookieUtil.USER_ID, getUserId(request) + "");
                Manager manager = managerService.getObjectById(getUserId(request));

                model.addAttribute("code", 0);
                model.addAttribute("result", GsonUtil.toJson(manager));
            } else {
                model.addAttribute("code", -5001);
                model.addAttribute("result", null);
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("manager logout error  ");
            model.addAttribute("code", -5001);
            model.addAttribute("result", null);
        }
        return "/data/json";
    }

    /**
     * sso登录
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/hello", method = RequestMethod.GET)
    public String casLogin(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        loginLog.info(" welcome cas manager login ");

        String loginName = "";
        try {
            AttributePrincipal pricipal = (AttributePrincipal) request.getUserPrincipal();
            loginLog.info(pricipal);
            if (pricipal != null && !pricipal.equals("")) {
                loginName = pricipal.getName();
            } else {
                loginName="admin";
            }

            loginLog.info(" loginName:  "+loginName);
            List<Long> mids = managerService.getManagerIdsByName(loginName, 0, Integer.MAX_VALUE);
            if(CollectionUtils.isNotEmpty(mids)){
                Manager manager = managerService.getObjectById(mids.get(0));
                String token = TokenUtils.createToken(manager.getId());
                loginLog.info("maxAge :" + cookieUtil.getMaxAge());
                RequestUtil.setCookie(response, cookieUtil.getLoginName(), token, cookieUtil.getMaxAge(), cookieUtil.getDomain(), "/");
            }
            else{
                request.getSession().invalidate();
                Cookie[] cookies = request.getCookies();
                for (Cookie cookie : cookies) {
                    cookie.setMaxAge(0);
                    cookie.setValue("");
                    cookie.setPath("/");
                    cookie.setDomain(cookieUtil.getDomain());
                    response.addCookie(cookie);
                }
            }

        } catch (Exception e) {
            loginLog.error(e.getMessage());
            loginLog.error("manager logout error ");
            model.addAttribute("code", -1);
        }
        return "/casLogin";
    }
    @RequestMapping(value = "/a/helloabc", method = RequestMethod.GET)
    public String helloabc(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        loginLog.info(" welcome cas manager login ");

        String loginName = "admin";
        try {
            loginLog.info(" loginName:  "+loginName);
            List<Long> mids = managerService.getManagerIdsByName(loginName, 0, Integer.MAX_VALUE);
            Manager manager = managerService.getObjectById(mids.get(0));

            String token = TokenUtils.createToken(manager.getId());
            loginLog.info("maxAge :" + cookieUtil.getMaxAge());
            RequestUtil.setCookie(response, cookieUtil.getLoginName(), token, cookieUtil.getMaxAge(), cookieUtil.getDomain(), "/");

        } catch (Exception e) {
            loginLog.error(e.getMessage());
            loginLog.error("manager logout error ");
            model.addAttribute("code", -1);
        }

        return "/casLogin";
    }
}
